/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.CamelContext;
import org.apache.camel.Expression;
import org.apache.camel.ServiceStatus;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.management.ManagementTestSupport;
import org.junit.Test;

public class ManagedProducerRecipientListRegisterAlwaysTest
extends ManagementTestSupport {
    protected CamelContext createCamelContext() throws Exception {
        CamelContext context = super.createCamelContext();
        context.init();
        context.getManagementStrategy().getManagementAgent().setRegisterAlways(Boolean.valueOf(true));
        return context;
    }

    @Test
    public void testProducer() throws Exception {
        if (ManagedProducerRecipientListRegisterAlwaysTest.isPlatform((String)"aix")) {
            return;
        }
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBodyAndHeader("direct:start", (Object)"Hello World", "foo", (Object)"mock:result");
        this.assertMockEndpointsSatisfied();
        MBeanServer mbeanServer = this.getMBeanServer();
        Set<ObjectName> set = mbeanServer.queryNames(new ObjectName("*:type=producers,*"), null);
        ManagedProducerRecipientListRegisterAlwaysTest.assertEquals((long)2L, (long)set.size());
        for (ObjectName on : set) {
            boolean registered = mbeanServer.isRegistered(on);
            ManagedProducerRecipientListRegisterAlwaysTest.assertEquals((String)"Should be registered", (Object)true, (Object)registered);
            String uri = (String)mbeanServer.getAttribute(on, "EndpointUri");
            ManagedProducerRecipientListRegisterAlwaysTest.assertTrue((String)uri, (uri.equals("direct://start") || uri.equals("mock://result") ? 1 : 0) != 0);
            String state = (String)mbeanServer.getAttribute(on, "State");
            ManagedProducerRecipientListRegisterAlwaysTest.assertEquals((String)"Should be started", (Object)ServiceStatus.Started.name(), (Object)state);
        }
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").routeId("foo").recipientList((Expression)this.header("foo"));
            }
        };
    }
}

