/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.CamelContext;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.management.DefaultManagementObjectNameStrategy;
import org.apache.camel.management.ManagementTestSupport;
import org.junit.Test;

public class ManagedNamePatternIncludeHostNameTest
extends ManagementTestSupport {
    protected CamelContext createCamelContext() throws Exception {
        CamelContext context = super.createCamelContext();
        context.init();
        DefaultManagementObjectNameStrategy naming = (DefaultManagementObjectNameStrategy)context.getManagementStrategy().getManagementObjectNameStrategy();
        naming.setHostName("localhost");
        context.getManagementStrategy().getManagementAgent().setIncludeHostName(Boolean.valueOf(true));
        context.getManagementNameStrategy().setNamePattern("cool-#name#");
        return context;
    }

    @Test
    public void testManagedNamePattern() throws Exception {
        if (ManagedNamePatternIncludeHostNameTest.isPlatform((String)"aix")) {
            return;
        }
        MBeanServer mbeanServer = this.getMBeanServer();
        ManagedNamePatternIncludeHostNameTest.assertTrue((boolean)this.context.getManagementName().startsWith("cool"));
        ObjectName on = ObjectName.getInstance("org.apache.camel:context=localhost/" + this.context.getManagementName() + ",type=context,name=\"camel-1\"");
        ManagedNamePatternIncludeHostNameTest.assertTrue((String)"Should be registered", (boolean)mbeanServer.isRegistered(on));
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").to("mock:result");
            }
        };
    }
}

