/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.List;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.Exchange;
import org.apache.camel.MessageHistory;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.StepDefinition;
import org.junit.Test;

public class ManagedMessageHistoryTest
extends ManagementTestSupport {
    @Test
    public void testStepOnly() throws Exception {
        this.getMockEndpoint("mock:a").expectedMessageCount(1);
        this.getMockEndpoint("mock:b").expectedMessageCount(1);
        this.getMockEndpoint("mock:bar").expectedMessageCount(1);
        Exchange out = this.template.request("direct:start", e -> e.getMessage().setBody((Object)"Hello World"));
        this.assertMockEndpointsSatisfied();
        List history = (List)out.getProperty("CamelMessageHistory", List.class);
        ManagedMessageHistoryTest.assertNotNull((Object)history);
        ManagedMessageHistoryTest.assertEquals((long)3L, (long)history.size());
        ManagedMessageHistoryTest.assertEquals((Object)"step", (Object)((MessageHistory)history.get(0)).getNode().getShortName());
        ManagedMessageHistoryTest.assertEquals((Object)"a", (Object)((MessageHistory)history.get(0)).getNode().getId());
        ManagedMessageHistoryTest.assertEquals((Object)"step", (Object)((MessageHistory)history.get(1)).getNode().getShortName());
        ManagedMessageHistoryTest.assertEquals((Object)"b", (Object)((MessageHistory)history.get(1)).getNode().getId());
        ManagedMessageHistoryTest.assertEquals((Object)"step", (Object)((MessageHistory)history.get(2)).getNode().getShortName());
        ManagedMessageHistoryTest.assertEquals((Object)"bar", (Object)((MessageHistory)history.get(2)).getNode().getId());
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = ObjectName.getInstance("org.apache.camel:context=camel-1,type=context,name=\"camel-1\"");
        ManagedMessageHistoryTest.assertTrue((String)"Should be registered", (boolean)mbeanServer.isRegistered(on));
        String name = (String)mbeanServer.getAttribute(on, "CamelId");
        ManagedMessageHistoryTest.assertEquals((Object)"camel-1", (Object)name);
        Boolean mh = (Boolean)mbeanServer.getAttribute(on, "MessageHistory");
        ManagedMessageHistoryTest.assertEquals((Object)Boolean.TRUE, (Object)mh);
        on = ObjectName.getInstance("org.apache.camel:context=camel-1,type=services,name=DefaultMessageHistoryFactory");
        ManagedMessageHistoryTest.assertTrue((String)"Should be registered", (boolean)mbeanServer.isRegistered(on));
        Boolean en = (Boolean)mbeanServer.getAttribute(on, "Enabled");
        ManagedMessageHistoryTest.assertEquals((Object)Boolean.TRUE, (Object)en);
        Boolean cm = (Boolean)mbeanServer.getAttribute(on, "CopyMessage");
        ManagedMessageHistoryTest.assertEquals((Object)Boolean.FALSE, (Object)cm);
        String np = (String)mbeanServer.getAttribute(on, "NodePattern");
        ManagedMessageHistoryTest.assertEquals((Object)"step", (Object)np);
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ManagedMessageHistoryTest.this.context.setMessageHistory(Boolean.valueOf(true));
                ManagedMessageHistoryTest.this.context.getMessageHistoryFactory().setNodePattern("step");
                ((StepDefinition)((StepDefinition)((StepDefinition)((StepDefinition)this.from("direct:start").step("a").to("log:foo")).to("mock:a")).end().step("b").to("direct:bar")).to("mock:b")).end();
                ((StepDefinition)((StepDefinition)this.from("direct:bar").step("bar").to("log:bar")).to("mock:bar")).end();
            }
        };
    }
}

