/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.openmbean.TabularData;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.RouteDefinition;
import org.junit.Assert;
import org.junit.Test;

public class ManagedInflightRepositoryBrowseTest
extends ManagementTestSupport {
    @Test
    public void testInflightRepository() throws Exception {
        if (ManagedInflightRepositoryBrowseTest.isPlatform((String)"aix")) {
            return;
        }
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ManagedInflightRepositoryBrowseTest.this.context.getInflightRepository().setInflightBrowseEnabled(true);
                ((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from("direct:start").routeId("foo").to("mock:a")).process(exchange -> {
                    MBeanServer mbeanServer = ManagedInflightRepositoryBrowseTest.this.getMBeanServer();
                    ObjectName name = ObjectName.getInstance("org.apache.camel:context=camel-1,type=services,name=DefaultInflightRepository");
                    Integer size = (Integer)mbeanServer.getAttribute(name, "Size");
                    Assert.assertEquals((long)1L, (long)size.intValue());
                    Integer routeSize = (Integer)mbeanServer.invoke(name, "size", new Object[]{"foo"}, new String[]{"java.lang.String"});
                    Assert.assertEquals((long)1L, (long)routeSize.intValue());
                    TabularData data = (TabularData)mbeanServer.invoke(name, "browse", null, null);
                    Assert.assertNotNull((Object)data);
                    Assert.assertEquals((long)1L, (long)data.size());
                })).id("myProcessor")).to("mock:result");
            }
        };
    }
}

