/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.CamelContext;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.rest.DummyRestConsumerFactory;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.RouteDefinition;
import org.junit.Test;

public class ManagedFromRestGetEmbeddedRouteTest
extends ManagementTestSupport {
    protected CamelContext createCamelContext() throws Exception {
        CamelContext context = super.createCamelContext();
        context.getRegistry().bind("dummy-test", (Object)new DummyRestConsumerFactory());
        return context;
    }

    @Test
    public void testFromRestModel() throws Exception {
        if (ManagedFromRestGetEmbeddedRouteTest.isPlatform((String)"aix")) {
            return;
        }
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = ObjectName.getInstance("org.apache.camel:context=camel-1,type=context,name=\"camel-1\"");
        String xml = (String)mbeanServer.invoke(on, "dumpRestsAsXml", null, null);
        ManagedFromRestGetEmbeddedRouteTest.assertNotNull((Object)xml);
        this.log.info(xml);
        ManagedFromRestGetEmbeddedRouteTest.assertTrue((boolean)xml.contains("<rests"));
        ManagedFromRestGetEmbeddedRouteTest.assertTrue((boolean)xml.contains("<rest path=\"/say/hello\">"));
        ManagedFromRestGetEmbeddedRouteTest.assertTrue((boolean)xml.contains("<rest path=\"/say/bye\">"));
        ManagedFromRestGetEmbeddedRouteTest.assertTrue((boolean)xml.contains("</rest>"));
        ManagedFromRestGetEmbeddedRouteTest.assertTrue((boolean)xml.contains("<get"));
        ManagedFromRestGetEmbeddedRouteTest.assertTrue((boolean)xml.contains("<route"));
        ManagedFromRestGetEmbeddedRouteTest.assertTrue((boolean)xml.contains("<transform"));
        ManagedFromRestGetEmbeddedRouteTest.assertTrue((boolean)xml.contains("<post"));
        ManagedFromRestGetEmbeddedRouteTest.assertTrue((boolean)xml.contains("application/json"));
        ManagedFromRestGetEmbeddedRouteTest.assertTrue((boolean)xml.contains("</rests>"));
        String xml2 = (String)mbeanServer.invoke(on, "dumpRoutesAsXml", null, null);
        this.log.info(xml2);
        ManagedFromRestGetEmbeddedRouteTest.assertTrue((boolean)xml2.contains("rest=\"true\""));
        ManagedFromRestGetEmbeddedRouteTest.assertEquals((long)3L, (long)this.context.getRouteDefinitions().size());
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.restConfiguration().host("localhost");
                ((RouteDefinition)this.rest("/say/hello").get().route().to("mock:hello")).transform((Expression)this.constant("Hello World"));
                ((RouteDefinition)((RouteDefinition)this.rest("/say/bye").get().consumes("application/json").route().to("mock:bye")).transform((Expression)this.constant("Bye World"))).endRest().post().to("mock:update");
            }
        };
    }
}

