/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.io.IOException;
import java.sql.SQLException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.openmbean.TabularData;
import org.apache.camel.ServiceStatus;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.LoadBalanceDefinition;
import org.junit.Test;

public class ManagedFailoverLoadBalancerTest
extends ManagementTestSupport {
    @Test
    public void testManageFailoverLoadBalancer() throws Exception {
        if (ManagedFailoverLoadBalancerTest.isPlatform((String)"aix")) {
            return;
        }
        this.getMockEndpoint("mock:foo").whenAnyExchangeReceived(exchange -> {
            throw new IOException("Forced");
        });
        MockEndpoint bar = this.getMockEndpoint("mock:bar");
        bar.expectedMessageCount(1);
        this.template.sendBodyAndHeader("direct:start", (Object)"Hello World", "foo", (Object)"123");
        this.assertMockEndpointsSatisfied();
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = ObjectName.getInstance("org.apache.camel:context=camel-1,type=processors,name=\"mysend\"");
        String routeId = (String)mbeanServer.getAttribute(on, "RouteId");
        ManagedFailoverLoadBalancerTest.assertEquals((Object)"route1", (Object)routeId);
        String camelId = (String)mbeanServer.getAttribute(on, "CamelId");
        ManagedFailoverLoadBalancerTest.assertEquals((Object)"camel-1", (Object)camelId);
        String state = (String)mbeanServer.getAttribute(on, "State");
        ManagedFailoverLoadBalancerTest.assertEquals((Object)ServiceStatus.Started.name(), (Object)state);
        Integer size = (Integer)mbeanServer.getAttribute(on, "Size");
        ManagedFailoverLoadBalancerTest.assertEquals((long)2L, (long)size.intValue());
        Boolean roundRobin = (Boolean)mbeanServer.getAttribute(on, "RoundRobin");
        ManagedFailoverLoadBalancerTest.assertEquals((Object)true, (Object)roundRobin);
        Boolean sticky = (Boolean)mbeanServer.getAttribute(on, "Sticky");
        ManagedFailoverLoadBalancerTest.assertEquals((Object)true, (Object)sticky);
        Integer attempts = (Integer)mbeanServer.getAttribute(on, "MaximumFailoverAttempts");
        ManagedFailoverLoadBalancerTest.assertEquals((long)3L, (long)attempts.intValue());
        String exceptions = (String)mbeanServer.getAttribute(on, "Exceptions");
        ManagedFailoverLoadBalancerTest.assertEquals((Object)"java.io.IOException,java.sql.SQLException", (Object)exceptions);
        String id = (String)mbeanServer.getAttribute(on, "LastGoodProcessorId");
        ManagedFailoverLoadBalancerTest.assertEquals((Object)"bar", (Object)id);
        TabularData data = (TabularData)mbeanServer.invoke(on, "exceptionStatistics", null, null);
        ManagedFailoverLoadBalancerTest.assertNotNull((Object)data);
        ManagedFailoverLoadBalancerTest.assertEquals((long)2L, (long)data.size());
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((LoadBalanceDefinition)((LoadBalanceDefinition)((LoadBalanceDefinition)((LoadBalanceDefinition)this.from("direct:start").loadBalance().failover(3, false, true, true, new Class[]{IOException.class, SQLException.class}).id("mysend")).to("mock:foo")).id("foo")).to("mock:bar")).id("bar");
            }
        };
    }
}

