/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.openmbean.TabularData;
import org.apache.camel.Predicate;
import org.apache.camel.ServiceStatus;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.ChoiceDefinition;
import org.junit.Test;

public class ManagedChoiceTest
extends ManagementTestSupport {
    @Test
    public void testManageChoice() throws Exception {
        if (ManagedChoiceTest.isPlatform((String)"aix")) {
            return;
        }
        this.getMockEndpoint("mock:foo").expectedMessageCount(2);
        this.getMockEndpoint("mock:bar").expectedMessageCount(1);
        this.template.sendBodyAndHeader("direct:start", (Object)"Hello World", "foo", (Object)"123");
        this.template.sendBodyAndHeader("direct:start", (Object)"Bye World", "foo", (Object)"456");
        this.template.sendBodyAndHeader("direct:start", (Object)"Hi World", "bar", (Object)"789");
        this.assertMockEndpointsSatisfied();
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = ObjectName.getInstance("org.apache.camel:context=camel-1,type=processors,name=\"mysend\"");
        String routeId = (String)mbeanServer.getAttribute(on, "RouteId");
        ManagedChoiceTest.assertEquals((Object)"route1", (Object)routeId);
        String camelId = (String)mbeanServer.getAttribute(on, "CamelId");
        ManagedChoiceTest.assertEquals((Object)"camel-1", (Object)camelId);
        String state = (String)mbeanServer.getAttribute(on, "State");
        ManagedChoiceTest.assertEquals((Object)ServiceStatus.Started.name(), (Object)state);
        TabularData data = (TabularData)mbeanServer.invoke(on, "choiceStatistics", null, null);
        ManagedChoiceTest.assertNotNull((Object)data);
        ManagedChoiceTest.assertEquals((long)2L, (long)data.size());
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((ChoiceDefinition)((ChoiceDefinition)this.from("direct:start").choice().id("mysend")).when((Predicate)this.header("foo")).to("mock:foo")).otherwise().to("mock:bar");
            }
        };
    }
}

