/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.CamelContext;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.management.ManagementTestSupport;
import org.junit.Test;

public class ManagedCamelContextPropertiesTest
extends ManagementTestSupport {
    protected CamelContext createCamelContext() throws Exception {
        CamelContext context = super.createCamelContext();
        context.init();
        context.getManagementNameStrategy().setNamePattern("19-#name#");
        return context;
    }

    @Test
    public void testGetSetProperties() throws Exception {
        if (ManagedCamelContextPropertiesTest.isPlatform((String)"aix")) {
            return;
        }
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = ObjectName.getInstance("org.apache.camel:context=19-camel-1,type=context,name=\"camel-1\"");
        ManagedCamelContextPropertiesTest.assertTrue((String)"Should be registered", (boolean)mbeanServer.isRegistered(on));
        String name = (String)mbeanServer.getAttribute(on, "CamelId");
        ManagedCamelContextPropertiesTest.assertEquals((Object)"camel-1", (Object)name);
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        mbeanServer.invoke(on, "setGlobalOption", new String[]{"CamelLogDebugBodyMaxChars", "-1"}, new String[]{"java.lang.String", "java.lang.String"});
        mbeanServer.invoke(on, "setGlobalOption", new String[]{"CamelLogDebugStreams", "true"}, new String[]{"java.lang.String", "java.lang.String"});
        Object invoke = mbeanServer.invoke(on, "getGlobalOption", new String[]{"CamelLogDebugBodyMaxChars"}, new String[]{"java.lang.String"});
        ManagedCamelContextPropertiesTest.assertEquals((Object)"-1", (Object)invoke);
        invoke = mbeanServer.invoke(on, "getGlobalOption", new String[]{"CamelLogDebugStreams"}, new String[]{"java.lang.String"});
        ManagedCamelContextPropertiesTest.assertEquals((Object)"true", (Object)invoke);
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").to("mock:result");
            }
        };
    }
}

