/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.Properties;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.Endpoint;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.model.FilterDefinition;
import org.apache.camel.model.RouteDefinition;
import org.junit.Test;

public class ManagedCamelContextDumpRoutesAsXmlTest
extends ManagementTestSupport {
    @Test
    public void testDumpAsXml() throws Exception {
        if (ManagedCamelContextDumpRoutesAsXmlTest.isPlatform((String)"aix")) {
            return;
        }
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = ObjectName.getInstance("org.apache.camel:context=camel-1,type=context,name=\"camel-1\"");
        String xml = (String)mbeanServer.invoke(on, "dumpRoutesAsXml", null, null);
        ManagedCamelContextDumpRoutesAsXmlTest.assertNotNull((Object)xml);
        this.log.info(xml);
        ManagedCamelContextDumpRoutesAsXmlTest.assertTrue((boolean)xml.contains("route"));
        ManagedCamelContextDumpRoutesAsXmlTest.assertTrue((boolean)xml.contains("myRoute"));
        ManagedCamelContextDumpRoutesAsXmlTest.assertTrue((boolean)xml.contains("myOtherRoute"));
        ManagedCamelContextDumpRoutesAsXmlTest.assertTrue((boolean)xml.contains("direct:start"));
        ManagedCamelContextDumpRoutesAsXmlTest.assertTrue((boolean)xml.contains("{{result}}"));
        ManagedCamelContextDumpRoutesAsXmlTest.assertTrue((boolean)xml.contains("seda:bar"));
        ManagedCamelContextDumpRoutesAsXmlTest.assertTrue((boolean)xml.contains("ref:bar"));
        ManagedCamelContextDumpRoutesAsXmlTest.assertTrue((boolean)xml.contains("<header>bar</header>"));
    }

    @Test
    public void testDumpAsXmlResolvePlaceholder() throws Exception {
        if (ManagedCamelContextDumpRoutesAsXmlTest.isPlatform((String)"aix")) {
            return;
        }
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = ObjectName.getInstance("org.apache.camel:context=camel-1,type=context,name=\"camel-1\"");
        String xml = (String)mbeanServer.invoke(on, "dumpRoutesAsXml", new Object[]{true}, new String[]{"boolean"});
        ManagedCamelContextDumpRoutesAsXmlTest.assertNotNull((Object)xml);
        this.log.info(xml);
        ManagedCamelContextDumpRoutesAsXmlTest.assertTrue((boolean)xml.contains("route"));
        ManagedCamelContextDumpRoutesAsXmlTest.assertTrue((boolean)xml.contains("myRoute"));
        ManagedCamelContextDumpRoutesAsXmlTest.assertTrue((boolean)xml.contains("myOtherRoute"));
        ManagedCamelContextDumpRoutesAsXmlTest.assertTrue((boolean)xml.contains("direct:start"));
        ManagedCamelContextDumpRoutesAsXmlTest.assertTrue((boolean)xml.contains("mock:result"));
        ManagedCamelContextDumpRoutesAsXmlTest.assertTrue((boolean)xml.contains("seda:bar"));
        ManagedCamelContextDumpRoutesAsXmlTest.assertTrue((boolean)xml.contains("ref:bar"));
        ManagedCamelContextDumpRoutesAsXmlTest.assertTrue((boolean)xml.contains("<header>bar</header>"));
    }

    @Test
    public void testDumpAsXmlResolvePlaceholderDelegateEndpoint() throws Exception {
        if (ManagedCamelContextDumpRoutesAsXmlTest.isPlatform((String)"aix")) {
            return;
        }
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = ObjectName.getInstance("org.apache.camel:context=camel-1,type=context,name=\"camel-1\"");
        String xml = (String)mbeanServer.invoke(on, "dumpRoutesAsXml", new Object[]{true, true}, new String[]{"boolean", "boolean"});
        ManagedCamelContextDumpRoutesAsXmlTest.assertNotNull((Object)xml);
        this.log.info(xml);
        ManagedCamelContextDumpRoutesAsXmlTest.assertTrue((boolean)xml.contains("route"));
        ManagedCamelContextDumpRoutesAsXmlTest.assertTrue((boolean)xml.contains("myRoute"));
        ManagedCamelContextDumpRoutesAsXmlTest.assertTrue((boolean)xml.contains("myOtherRoute"));
        ManagedCamelContextDumpRoutesAsXmlTest.assertTrue((boolean)xml.contains("direct:start"));
        ManagedCamelContextDumpRoutesAsXmlTest.assertTrue((boolean)xml.contains("mock:result"));
        ManagedCamelContextDumpRoutesAsXmlTest.assertTrue((boolean)xml.contains("bar"));
        ManagedCamelContextDumpRoutesAsXmlTest.assertTrue((boolean)xml.contains("seda:bar"));
        ManagedCamelContextDumpRoutesAsXmlTest.assertTrue((boolean)xml.contains("mock://bar"));
        ManagedCamelContextDumpRoutesAsXmlTest.assertTrue((boolean)xml.contains("<header>bar</header>"));
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                Properties props = new Properties();
                props.put("result", "mock:result");
                ManagedCamelContextDumpRoutesAsXmlTest.this.context.getPropertiesComponent().setOverrideProperties(props);
                Endpoint bar = ManagedCamelContextDumpRoutesAsXmlTest.this.context.getEndpoint("mock:bar");
                this.bindToRegistry("bar", bar);
                ((RouteDefinition)this.from("direct:start").routeId("myRoute").log("Got ${body}")).to("{{result}}");
                ((ExpressionNode)((FilterDefinition)this.from("seda:bar").routeId("myOtherRoute").filter().header("bar")).to("ref:bar")).end();
            }
        };
    }
}

