/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.lang.management.ManagementFactory;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.junit.Before;
import org.junit.Test;

public class JmxInstrumentationOnlyRegisterProcessorWithCustomIdTest
extends ContextTestSupport {
    protected String domainName = "org.apache.camel";
    protected MBeanServer server;

    protected boolean useJmx() {
        return true;
    }

    @Test
    public void testCustomId() throws Exception {
        if (JmxInstrumentationOnlyRegisterProcessorWithCustomIdTest.isPlatform((String)"aix")) {
            return;
        }
        Set<ObjectName> s = this.server.queryNames(new ObjectName(this.domainName + ":type=endpoints,*"), null);
        JmxInstrumentationOnlyRegisterProcessorWithCustomIdTest.assertEquals((String)("Could not find 2 endpoints: " + s), (long)6L, (long)s.size());
        s = this.server.queryNames(new ObjectName(this.domainName + ":type=context,*"), null);
        JmxInstrumentationOnlyRegisterProcessorWithCustomIdTest.assertEquals((String)("Could not find 1 context: " + s), (long)1L, (long)s.size());
        s = this.server.queryNames(new ObjectName(this.domainName + ":type=processors,*"), null);
        JmxInstrumentationOnlyRegisterProcessorWithCustomIdTest.assertEquals((String)("Could not find 1 processor: " + s), (long)1L, (long)s.size());
        ObjectName on = s.iterator().next();
        String id = (String)this.server.getAttribute(on, "ProcessorId");
        JmxInstrumentationOnlyRegisterProcessorWithCustomIdTest.assertEquals((Object)"myfoo", (Object)id);
        s = this.server.queryNames(new ObjectName(this.domainName + ":type=routes,*"), null);
        JmxInstrumentationOnlyRegisterProcessorWithCustomIdTest.assertEquals((String)("Could not find 2 route: " + s), (long)2L, (long)s.size());
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    protected CamelContext createCamelContext() throws Exception {
        CamelContext context = super.createCamelContext();
        context.init();
        context.getManagementStrategy().getManagementAgent().setOnlyRegisterProcessorWithCustomId(Boolean.valueOf(true));
        return context;
    }

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.server = ManagementFactory.getPlatformMBeanServer();
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)((RouteDefinition)this.from("direct:start").to("mock:foo")).id("myfoo")).delay(10L).to("mock:result");
                ((RouteDefinition)this.from("direct:other").to("mock:bar")).delay(10L).to("mock:other");
            }
        };
    }
}

