/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.ExchangePattern;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.junit.Test;

public class ExceptionWithManagementTest
extends ContextTestSupport {
    protected boolean useJmx() {
        return true;
    }

    @Test
    public void testExceptionHandler() throws Exception {
        MockEndpoint error = (MockEndpoint)this.resolveMandatoryEndpoint("mock:error", MockEndpoint.class);
        error.expectedMessageCount(1);
        MockEndpoint out = (MockEndpoint)this.resolveMandatoryEndpoint("mock:out", MockEndpoint.class);
        out.expectedMessageCount(0);
        this.template.send("direct:start", ExchangePattern.InOnly, exchange -> exchange.getIn().setBody((Object)"hello"));
        error.assertIsSatisfied();
        out.assertIsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.errorHandler((ErrorHandlerBuilder)this.deadLetterChannel("mock:error").redeliveryDelay(0L).maximumRedeliveries(3));
                this.onException(IllegalArgumentException.class).redeliveryDelay(0L).maximumRedeliveries(1).to("mock:error");
                ((RouteDefinition)this.from("direct:start").process(exchange -> {
                    throw new IllegalArgumentException("intentional error");
                })).to("mock:out");
            }
        };
    }
}

