/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.List;
import javax.management.Attribute;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.Exchange;
import org.apache.camel.api.management.mbean.BacklogTracerEventMessage;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.RouteDefinition;
import org.junit.Test;

public class BacklogTracerPatternTest
extends ManagementTestSupport {
    @Test
    public void testBacklogTracerPattern() throws Exception {
        if (BacklogTracerPatternTest.isPlatform((String)"aix")) {
            return;
        }
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = new ObjectName("org.apache.camel:context=camel-1,type=tracer,name=BacklogTracer");
        BacklogTracerPatternTest.assertNotNull((Object)on);
        mbeanServer.isRegistered(on);
        Boolean enabled = (Boolean)mbeanServer.getAttribute(on, "Enabled");
        BacklogTracerPatternTest.assertEquals((String)"Should not be enabled", (Object)Boolean.FALSE, (Object)enabled);
        Integer size = (Integer)mbeanServer.getAttribute(on, "BacklogSize");
        BacklogTracerPatternTest.assertEquals((String)"Should be 1000", (long)1000L, (long)size.intValue());
        mbeanServer.setAttribute(on, new Attribute("TracePattern", "foo*"));
        mbeanServer.setAttribute(on, new Attribute("Enabled", Boolean.TRUE));
        this.getMockEndpoint("mock:foo").expectedMessageCount(2);
        this.getMockEndpoint("mock:bar").expectedMessageCount(2);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.template.sendBody("direct:start", (Object)"Bye World");
        this.assertMockEndpointsSatisfied();
        List exchanges = this.getMockEndpoint("mock:foo").getReceivedExchanges();
        List events = (List)mbeanServer.invoke(on, "dumpTracedMessages", new Object[]{"foo"}, new String[]{"java.lang.String"});
        BacklogTracerPatternTest.assertNotNull((Object)events);
        BacklogTracerPatternTest.assertEquals((long)2L, (long)events.size());
        BacklogTracerEventMessage event1 = (BacklogTracerEventMessage)events.get(0);
        BacklogTracerPatternTest.assertEquals((Object)"foo", (Object)event1.getToNode());
        BacklogTracerPatternTest.assertEquals((Object)("    <message exchangeId=\"" + ((Exchange)exchanges.get(0)).getExchangeId() + "\">\n      <body type=\"java.lang.String\">Hello World</body>\n    </message>"), (Object)event1.getMessageAsXml());
        BacklogTracerEventMessage event2 = (BacklogTracerEventMessage)events.get(1);
        BacklogTracerPatternTest.assertEquals((Object)"foo", (Object)event2.getToNode());
        BacklogTracerPatternTest.assertEquals((Object)("    <message exchangeId=\"" + ((Exchange)exchanges.get(1)).getExchangeId() + "\">\n      <body type=\"java.lang.String\">Bye World</body>\n    </message>"), (Object)event2.getMessageAsXml());
        events = (List)mbeanServer.invoke(on, "dumpTracedMessages", new Object[]{"bar"}, new String[]{"java.lang.String"});
        BacklogTracerPatternTest.assertNotNull((Object)events);
        BacklogTracerPatternTest.assertEquals((long)0L, (long)events.size());
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                BacklogTracerPatternTest.this.context.setUseBreadcrumb(Boolean.valueOf(false));
                BacklogTracerPatternTest.this.context.setBacklogTracing(Boolean.valueOf(true));
                ((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from("direct:start").to("mock:foo")).id("foo")).to("mock:bar")).id("bar");
            }
        };
    }
}

