/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.ArrayList;
import java.util.List;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.CamelEvent;
import org.apache.camel.spi.EventNotifier;
import org.apache.camel.support.EventNotifierSupport;
import org.junit.Before;
import org.junit.Test;

public class AddEventNotifierTest
extends ContextTestSupport {
    private static List<CamelEvent> events = new ArrayList<CamelEvent>();
    private EventNotifier notifier;

    @Before
    public void setUp() throws Exception {
        events.clear();
        super.setUp();
    }

    @Test
    public void testAddAndRemove() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        AddEventNotifierTest.assertEquals((long)0L, (long)events.size());
        this.notifier = new EventNotifierSupport(){

            public void notify(CamelEvent event) throws Exception {
                events.add(event);
            }
        };
        this.context.addService((Object)this.notifier);
        this.context.getManagementStrategy().addEventNotifier(this.notifier);
        this.resetMocks();
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Bye World");
        this.assertMockEndpointsSatisfied();
        AddEventNotifierTest.assertEquals((long)8L, (long)events.size());
        this.context.getManagementStrategy().removeEventNotifier(this.notifier);
        this.resetMocks();
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hi World");
        this.assertMockEndpointsSatisfied();
        AddEventNotifierTest.assertEquals((long)8L, (long)events.size());
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:start").to("log:foo")).to("mock:result");
            }
        };
    }
}

