/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.xslt;

import java.util.ArrayList;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.junit.Before;
import org.junit.Test;

public class XsltContentCacheTest
extends ContextTestSupport {
    private static final String ORIGINAL_XSL = "<xsl:stylesheet version=\"1.0\" xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\"><xsl:template match=\"/\"><goodbye><xsl:value-of select=\"/hello\"/></goodbye></xsl:template></xsl:stylesheet>";
    private static final String NEW_XSL = "<xsl:stylesheet version=\"1.0\" xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\"><xsl:template match=\"/\"><goodnight><xsl:value-of select=\"/hello\"/></goodnight></xsl:template></xsl:stylesheet>";

    public boolean isUseRouteBuilder() {
        return false;
    }

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.context.start();
        this.template.sendBodyAndHeader("file://target/test-classes/org/apache/camel/component/xslt?fileExist=Override", (Object)ORIGINAL_XSL, "CamelFileName", (Object)"hello.xsl");
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:a").to("xslt://org/apache/camel/component/xslt/hello.xsl?output=string&contentCache=false")).to("mock:result");
                ((RouteDefinition)this.from("direct:b").to("xslt://org/apache/camel/component/xslt/hello.xsl?output=string&contentCache=true")).to("mock:result");
                ((RouteDefinition)this.from("direct:c").to("xslt://org/apache/camel/component/xslt/hello.xsl?output=string")).to("mock:result");
            }
        });
    }

    public boolean useJmx() {
        return true;
    }

    @Test
    public void testNotCached() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"<?xml version=\"1.0\" encoding=\"UTF-8\"?><goodbye>world!</goodbye>"});
        this.template.sendBody("direct:a", (Object)"<hello>world!</hello>");
        mock.assertIsSatisfied();
        this.template.sendBodyAndHeader("file://target/test-classes/org/apache/camel/component/xslt?fileExist=Override", (Object)NEW_XSL, "CamelFileName", (Object)"hello.xsl");
        mock.reset();
        mock.expectedBodiesReceived(new Object[]{"<?xml version=\"1.0\" encoding=\"UTF-8\"?><goodnight>world!</goodnight>"});
        this.template.sendBody("direct:a", (Object)"<hello>world!</hello>");
        mock.assertIsSatisfied();
    }

    @Test
    public void testCached() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"<?xml version=\"1.0\" encoding=\"UTF-8\"?><goodbye>world!</goodbye>"});
        this.template.sendBody("direct:b", (Object)"<hello>world!</hello>");
        mock.assertIsSatisfied();
        this.template.sendBodyAndHeader("file://target/test-classes/org/apache/camel/component/xslt?fileExist=Override", (Object)NEW_XSL, "CamelFileName", (Object)"hello.xsl");
        mock.reset();
        mock.expectedBodiesReceived(new Object[]{"<?xml version=\"1.0\" encoding=\"UTF-8\"?><goodbye>world!</goodbye>"});
        this.template.sendBody("direct:b", (Object)"<hello>world!</hello>");
        mock.assertIsSatisfied();
    }

    @Test
    public void testCachedIsDefault() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"<?xml version=\"1.0\" encoding=\"UTF-8\"?><goodbye>world!</goodbye>"});
        this.template.sendBody("direct:c", (Object)"<hello>world!</hello>");
        mock.assertIsSatisfied();
        this.template.sendBodyAndHeader("file://target/test-classes/org/apache/camel/component/xslt?fileExist=Override", (Object)NEW_XSL, "CamelFileName", (Object)"hello.xsl");
        mock.reset();
        mock.expectedBodiesReceived(new Object[]{"<?xml version=\"1.0\" encoding=\"UTF-8\"?><goodbye>world!</goodbye>"});
        this.template.sendBody("direct:c", (Object)"<hello>world!</hello>");
        mock.assertIsSatisfied();
    }

    @Test
    public void testClearCachedStylesheetViaJmx() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"<?xml version=\"1.0\" encoding=\"UTF-8\"?><goodbye>world!</goodbye>"});
        this.template.sendBody("direct:b", (Object)"<hello>world!</hello>");
        mock.assertIsSatisfied();
        this.template.sendBodyAndHeader("file://target/test-classes/org/apache/camel/component/xslt?fileExist=Override", (Object)NEW_XSL, "CamelFileName", (Object)"hello.xsl");
        mock.reset();
        mock.expectedBodiesReceived(new Object[]{"<?xml version=\"1.0\" encoding=\"UTF-8\"?><goodbye>world!</goodbye>"});
        this.template.sendBody("direct:b", (Object)"<hello>world!</hello>");
        mock.assertIsSatisfied();
        MBeanServer mbeanServer = this.context.getManagementStrategy().getManagementAgent().getMBeanServer();
        Set<ObjectName> objNameSet = mbeanServer.queryNames(new ObjectName("org.apache.camel:type=endpoints,name=\"xslt:*contentCache=true*\",*"), null);
        ObjectName managedObjName = new ArrayList<ObjectName>(objNameSet).get(0);
        mbeanServer.invoke(managedObjName, "clearCachedStylesheet", null, null);
        this.template.sendBodyAndHeader("file://target/test-classes/org/apache/camel/component/xslt?fileExist=Override", (Object)NEW_XSL, "CamelFileName", (Object)"hello.xsl");
        mock.reset();
        mock.expectedBodiesReceived(new Object[]{"<?xml version=\"1.0\" encoding=\"UTF-8\"?><goodnight>world!</goodnight>"});
        this.template.sendBody("direct:b", (Object)"<hello>world!</hello>");
        mock.assertIsSatisfied();
    }
}

