/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.AsyncCallback;
import org.apache.camel.CamelContext;
import org.apache.camel.Consumer;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.support.DefaultAsyncProducer;
import org.apache.camel.support.DefaultEndpoint;
import org.junit.Test;

public class ReduceStacksNeededDuringRoutingSendProcessorTest
extends ContextTestSupport {
    protected boolean useJmx() {
        return true;
    }

    @Test
    public void testReduceStacksNeeded() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBody("seda:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                MyEndpoint my = new MyEndpoint("myendpoint:foo", this.getContext());
                ((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from("seda:start").to("log:foo")).to("log:bar")).to("log:baz")).to((Endpoint)my)).to("mock:result");
            }
        };
    }

    public static final class MyProducer
    extends DefaultAsyncProducer {
        public MyProducer(Endpoint endpoint) {
            super(endpoint);
        }

        public boolean process(Exchange exchange, AsyncCallback callback) {
            try {
                throw new IllegalArgumentException("Forced to dump stacktrace");
            }
            catch (Exception e) {
                e.fillInStackTrace();
                this.log.info("There are " + e.getStackTrace().length + " lines in the stacktrace");
                this.log.error("Dump stacktrace to log", (Throwable)e);
                callback.done(true);
                return true;
            }
        }
    }

    public static final class MyEndpoint
    extends DefaultEndpoint {
        public MyEndpoint(String uri, CamelContext context) {
            super("myendpoint:foo", null);
            this.setCamelContext(context);
        }

        public Producer createProducer() throws Exception {
            return new MyProducer((Endpoint)this);
        }

        public Consumer createConsumer(Processor processor) throws Exception {
            return null;
        }

        public boolean isSingleton() {
            return true;
        }
    }
}

