/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.ServiceStatus;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.LoadBalanceDefinition;
import org.junit.Test;

public class ManagedWeightedLoadBalancerTest
extends ManagementTestSupport {
    @Test
    public void testManageWeightedLoadBalancer() throws Exception {
        if (ManagedWeightedLoadBalancerTest.isPlatform((String)"aix")) {
            return;
        }
        MockEndpoint foo = this.getMockEndpoint("mock:foo");
        foo.expectedMessageCount(1);
        MockEndpoint bar = this.getMockEndpoint("mock:bar");
        bar.expectedMessageCount(2);
        this.template.sendBodyAndHeader("direct:start", (Object)"Hello World", "foo", (Object)"123");
        this.template.sendBodyAndHeader("direct:start", (Object)"Bye World", "foo", (Object)"123");
        this.template.sendBodyAndHeader("direct:start", (Object)"Hi World", "foo", (Object)"123");
        this.assertMockEndpointsSatisfied();
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = ObjectName.getInstance("org.apache.camel:context=camel-1,type=processors,name=\"mysend\"");
        String routeId = (String)mbeanServer.getAttribute(on, "RouteId");
        ManagedWeightedLoadBalancerTest.assertEquals((Object)"route1", (Object)routeId);
        String camelId = (String)mbeanServer.getAttribute(on, "CamelId");
        ManagedWeightedLoadBalancerTest.assertEquals((Object)"camel-1", (Object)camelId);
        String state = (String)mbeanServer.getAttribute(on, "State");
        ManagedWeightedLoadBalancerTest.assertEquals((Object)ServiceStatus.Started.name(), (Object)state);
        Integer size = (Integer)mbeanServer.getAttribute(on, "Size");
        ManagedWeightedLoadBalancerTest.assertEquals((long)2L, (long)size.intValue());
        Boolean roundRobin = (Boolean)mbeanServer.getAttribute(on, "RoundRobin");
        ManagedWeightedLoadBalancerTest.assertEquals((Object)true, (Object)roundRobin);
        String ratio = (String)mbeanServer.getAttribute(on, "DistributionRatio");
        ManagedWeightedLoadBalancerTest.assertEquals((Object)"1,2", (Object)ratio);
        String delim = (String)mbeanServer.getAttribute(on, "DistributionRatioDelimiter");
        ManagedWeightedLoadBalancerTest.assertEquals((Object)",", (Object)delim);
        String last = (String)mbeanServer.getAttribute(on, "LastChosenProcessorId");
        ManagedWeightedLoadBalancerTest.assertEquals((Object)"bar", (Object)last);
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((LoadBalanceDefinition)((LoadBalanceDefinition)((LoadBalanceDefinition)((LoadBalanceDefinition)this.from("direct:start").loadBalance().weighted(true, "1,2").id("mysend")).to("mock:foo")).id("foo")).to("mock:bar")).id("bar");
            }
        };
    }
}

