/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.ArrayList;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.TabularData;
import org.apache.camel.Message;
import org.apache.camel.ValidationException;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.spi.DataType;
import org.apache.camel.spi.Validator;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagedValidatorRegistryTest
extends ManagementTestSupport {
    private static final Logger LOG = LoggerFactory.getLogger(ManagedValidatorRegistryTest.class);

    @Test
    public void testManageValidatorRegistry() throws Exception {
        if (ManagedValidatorRegistryTest.isPlatform((String)"aix")) {
            return;
        }
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        MBeanServer mbeanServer = this.getMBeanServer();
        Set<ObjectName> set = mbeanServer.queryNames(new ObjectName("*:type=services,*"), null);
        ArrayList<ObjectName> list = new ArrayList<ObjectName>(set);
        ObjectName on = null;
        for (ObjectName name : list) {
            if (!name.getCanonicalName().contains("DefaultValidatorRegistry")) continue;
            on = name;
            break;
        }
        ManagedValidatorRegistryTest.assertNotNull((String)"Should have found ValidatorRegistry", on);
        Integer max = (Integer)mbeanServer.getAttribute(on, "MaximumCacheSize");
        ManagedValidatorRegistryTest.assertEquals((long)1000L, (long)max.intValue());
        Integer current = (Integer)mbeanServer.getAttribute(on, "Size");
        ManagedValidatorRegistryTest.assertEquals((long)3L, (long)current.intValue());
        current = (Integer)mbeanServer.getAttribute(on, "StaticSize");
        ManagedValidatorRegistryTest.assertEquals((long)0L, (long)current.intValue());
        current = (Integer)mbeanServer.getAttribute(on, "DynamicSize");
        ManagedValidatorRegistryTest.assertEquals((long)3L, (long)current.intValue());
        String source = (String)mbeanServer.getAttribute(on, "Source");
        ManagedValidatorRegistryTest.assertTrue((boolean)source.startsWith("ValidatorRegistry"));
        ManagedValidatorRegistryTest.assertTrue((boolean)source.endsWith("capacity: 1000"));
        TabularData data = (TabularData)mbeanServer.invoke(on, "listValidators", null, null);
        for (Object row : data.values()) {
            CompositeData composite = (CompositeData)row;
            String type = (String)composite.get("type");
            String description = (String)composite.get("description");
            boolean isStatic = (Boolean)composite.get("static");
            boolean isDynamic = (Boolean)composite.get("dynamic");
            LOG.info("[{}][{}][{}][{}]", new Object[]{type, isStatic, isDynamic, description});
            if (description.startsWith("ProcessorValidator")) {
                if (description.contains("direct://transformer")) {
                    ManagedValidatorRegistryTest.assertEquals((Object)"xml:foo", (Object)type);
                    continue;
                }
                if (description.contains("validate(simple{${body}} is not null")) {
                    ManagedValidatorRegistryTest.assertEquals((Object)"json:test", (Object)type);
                    continue;
                }
                ManagedValidatorRegistryTest.fail((String)("Unexpected validator:" + description));
                continue;
            }
            if (description.startsWith("MyValidator")) {
                ManagedValidatorRegistryTest.assertEquals((Object)"custom", (Object)type);
                continue;
            }
            ManagedValidatorRegistryTest.fail((String)("Unexpected validator:" + description));
        }
        ManagedValidatorRegistryTest.assertEquals((long)3L, (long)data.size());
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.validator().type("xml:foo").withUri("direct:transformer");
                this.validator().type("json:test").withExpression(this.body().isNotNull());
                this.validator().type("custom").withJava(MyValidator.class);
                this.from("direct:start").to("mock:result");
            }
        };
    }

    public static class MyValidator
    extends Validator {
        public void validate(Message message, DataType type) throws ValidationException {
        }
    }
}

