/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.management.ManagementTestSupport;
import org.junit.Test;

public class ManagedUnregisterProducerTest
extends ManagementTestSupport {
    @Test
    public void testUnregisterProducer() throws Exception {
        if (ManagedUnregisterProducerTest.isPlatform((String)"aix")) {
            return;
        }
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        MBeanServer mbeanServer = this.getMBeanServer();
        Set<ObjectName> set = mbeanServer.queryNames(new ObjectName("*:type=producers,*"), null);
        ManagedUnregisterProducerTest.assertEquals((long)1L, (long)set.size());
        ObjectName on = set.iterator().next();
        ManagedUnregisterProducerTest.assertTrue((String)"Should be registered", (boolean)mbeanServer.isRegistered(on));
        String uri = (String)mbeanServer.getAttribute(on, "EndpointUri");
        ManagedUnregisterProducerTest.assertEquals((Object)"mock://result", (Object)uri);
        Boolean singleton = (Boolean)mbeanServer.getAttribute(on, "Singleton");
        ManagedUnregisterProducerTest.assertEquals((Object)Boolean.TRUE, (Object)singleton);
        this.context.stop();
        ManagedUnregisterProducerTest.assertFalse((String)"Should no longer be registered", (boolean)mbeanServer.isRegistered(on));
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").to("mock:result");
            }
        };
    }
}

