/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.Set;
import javax.management.Attribute;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.ServiceStatus;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.management.ManagementTestSupport;
import org.junit.Test;

public class ManagedTimerTest
extends ManagementTestSupport {
    @Test
    public void testTimer() throws Exception {
        if (ManagedTimerTest.isPlatform((String)"aix")) {
            return;
        }
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName name = ObjectName.getInstance("org.apache.camel:context=camel-1,type=endpoints,name=\"timer://foo\\?delay=5000&period=8000\"");
        ManagedTimerTest.assertEquals((String)"Should be registered", (Object)true, (Object)mbeanServer.isRegistered(name));
        Long period = (Long)mbeanServer.getAttribute(name, "Period");
        ManagedTimerTest.assertEquals((long)8000L, (long)period);
        String camelId = (String)mbeanServer.getAttribute(name, "CamelId");
        ManagedTimerTest.assertEquals((Object)"camel-1", (Object)camelId);
        mbeanServer.setAttribute(name, new Attribute("Period", 500));
        mbeanServer.setAttribute(name, new Attribute("Delay", 250));
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.reset();
        Set<ObjectName> set = mbeanServer.queryNames(new ObjectName("*:type=consumers,*"), null);
        ManagedTimerTest.assertEquals((long)1L, (long)set.size());
        ObjectName on = set.iterator().next();
        mbeanServer.invoke(on, "stop", null, null);
        mbeanServer.invoke(on, "start", null, null);
        String state = (String)mbeanServer.getAttribute(on, "State");
        ManagedTimerTest.assertEquals((String)"Should be started", (Object)ServiceStatus.Started.name(), (Object)state);
        mock.expectedMinimumMessageCount(3);
        mock.setResultWaitTime(3900L);
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("timer://foo?delay=5000&period=8000").to("mock:result");
            }
        };
    }
}

