/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.ServiceStatus;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.RoutePolicy;
import org.apache.camel.throttling.ThrottlingInflightRoutePolicy;
import org.junit.Test;

public class ManagedThrottlingInflightRoutePolicyTest
extends ManagementTestSupport {
    @Test
    public void testRoutes() throws Exception {
        if (ManagedThrottlingInflightRoutePolicyTest.isPlatform((String)"aix")) {
            return;
        }
        MBeanServer mbeanServer = this.getMBeanServer();
        Set<ObjectName> set = mbeanServer.queryNames(new ObjectName("*:type=routes,*"), null);
        ManagedThrottlingInflightRoutePolicyTest.assertEquals((long)1L, (long)set.size());
        ObjectName on = set.iterator().next();
        boolean registered = mbeanServer.isRegistered(on);
        ManagedThrottlingInflightRoutePolicyTest.assertEquals((String)"Should be registered", (Object)true, (Object)registered);
        String uri = (String)mbeanServer.getAttribute(on, "EndpointUri");
        ManagedThrottlingInflightRoutePolicyTest.assertEquals((Object)"direct://start", (Object)uri);
        Long val = (Long)mbeanServer.getAttribute(on, "ExchangesInflight");
        ManagedThrottlingInflightRoutePolicyTest.assertEquals((long)0L, (long)val);
        String state = (String)mbeanServer.getAttribute(on, "State");
        ManagedThrottlingInflightRoutePolicyTest.assertEquals((String)"Should be started", (Object)ServiceStatus.Started.name(), (Object)state);
        String policy = (String)mbeanServer.getAttribute(on, "RoutePolicyList");
        ManagedThrottlingInflightRoutePolicyTest.assertNotNull((Object)policy);
        ManagedThrottlingInflightRoutePolicyTest.assertTrue((String)("Should be a throttling, was: " + policy), (boolean)policy.startsWith("ThrottlingInflightRoutePolicy"));
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:start").routePolicy(new RoutePolicy[]{new ThrottlingInflightRoutePolicy()}).to("log:foo")).to("mock:result");
            }
        };
    }
}

