/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.ThreadsDefinition;
import org.junit.Test;

public class ManagedThreadPoolWithIdTest
extends ManagementTestSupport {
    @Test
    public void testManagedThreadPool() throws Exception {
        if (ManagedThreadPoolWithIdTest.isPlatform((String)"aix")) {
            return;
        }
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = ObjectName.getInstance("org.apache.camel:context=camel-1,type=threadpools,name=\"myThreads(threads)\"");
        Boolean shutdown = (Boolean)mbeanServer.getAttribute(on, "Shutdown");
        ManagedThreadPoolWithIdTest.assertEquals((Object)false, (Object)shutdown);
        Integer corePoolSize = (Integer)mbeanServer.getAttribute(on, "CorePoolSize");
        ManagedThreadPoolWithIdTest.assertEquals((long)15L, (long)corePoolSize.intValue());
        Integer maxPoolSize = (Integer)mbeanServer.getAttribute(on, "MaximumPoolSize");
        ManagedThreadPoolWithIdTest.assertEquals((long)30L, (long)maxPoolSize.intValue());
        Integer poolSize = (Integer)mbeanServer.getAttribute(on, "PoolSize");
        ManagedThreadPoolWithIdTest.assertEquals((long)0L, (long)poolSize.intValue());
        Long keepAlive = (Long)mbeanServer.getAttribute(on, "KeepAliveTime");
        ManagedThreadPoolWithIdTest.assertEquals((long)60L, (long)keepAlive.intValue());
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        String id = (String)mbeanServer.getAttribute(on, "Id");
        ManagedThreadPoolWithIdTest.assertEquals((Object)"myThreads", (Object)id);
        String source = (String)mbeanServer.getAttribute(on, "SourceId");
        ManagedThreadPoolWithIdTest.assertEquals((Object)"threads", (Object)source);
        String routeId = (String)mbeanServer.getAttribute(on, "RouteId");
        ManagedThreadPoolWithIdTest.assertEquals((Object)"myRoute", (Object)routeId);
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((ThreadsDefinition)this.from("direct:start").routeId("myRoute").threads(15, 30).id("myThreads")).to("mock:result");
            }
        };
    }
}

