/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.management.ManagementTestSupport;
import org.junit.Test;

public class ManagedThreadPoolTest
extends ManagementTestSupport {
    @Test
    public void testManagedThreadPool() throws Exception {
        if (ManagedThreadPoolTest.isPlatform((String)"aix")) {
            return;
        }
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = ObjectName.getInstance("org.apache.camel:context=camel-1,type=threadpools,name=\"threads1(threads)\"");
        Boolean shutdown = (Boolean)mbeanServer.getAttribute(on, "Shutdown");
        ManagedThreadPoolTest.assertEquals((Object)false, (Object)shutdown);
        Integer corePoolSize = (Integer)mbeanServer.getAttribute(on, "CorePoolSize");
        ManagedThreadPoolTest.assertEquals((long)15L, (long)corePoolSize.intValue());
        Integer maxPoolSize = (Integer)mbeanServer.getAttribute(on, "MaximumPoolSize");
        ManagedThreadPoolTest.assertEquals((long)30L, (long)maxPoolSize.intValue());
        Integer poolSize = (Integer)mbeanServer.getAttribute(on, "PoolSize");
        ManagedThreadPoolTest.assertEquals((long)0L, (long)poolSize.intValue());
        Long keepAlive = (Long)mbeanServer.getAttribute(on, "KeepAliveTime");
        ManagedThreadPoolTest.assertEquals((long)60L, (long)keepAlive.intValue());
        Boolean allow = (Boolean)mbeanServer.getAttribute(on, "AllowCoreThreadTimeout");
        ManagedThreadPoolTest.assertEquals((Object)false, (Object)allow);
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        Thread.sleep(2000L);
        poolSize = (Integer)mbeanServer.getAttribute(on, "PoolSize");
        ManagedThreadPoolTest.assertEquals((long)1L, (long)poolSize.intValue());
        Integer largest = (Integer)mbeanServer.getAttribute(on, "LargestPoolSize");
        ManagedThreadPoolTest.assertEquals((long)1L, (long)largest.intValue());
        Long completed = (Long)mbeanServer.getAttribute(on, "CompletedTaskCount");
        ManagedThreadPoolTest.assertEquals((long)1L, (long)completed.intValue());
        Long size = (Long)mbeanServer.getAttribute(on, "TaskQueueSize");
        ManagedThreadPoolTest.assertEquals((long)0L, (long)size.intValue());
        Boolean empty = (Boolean)mbeanServer.getAttribute(on, "TaskQueueEmpty");
        ManagedThreadPoolTest.assertEquals((Object)true, (Object)empty);
        int remainingCapacity = (Integer)mbeanServer.invoke(on, "getTaskQueueRemainingCapacity", null, null);
        ManagedThreadPoolTest.assertEquals((String)"remainingCapacity", (long)200L, (long)remainingCapacity);
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").threads(15, 30).maxQueueSize(200).to("mock:result");
            }
        };
    }
}

