/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.CamelContext;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.RouteDefinition;
import org.junit.Test;

public class ManagedSanitizeTest
extends ManagementTestSupport {
    protected CamelContext createCamelContext() throws Exception {
        CamelContext context = super.createCamelContext();
        context.init();
        context.getManagementStrategy().getManagementAgent().setMask(Boolean.valueOf(true));
        return context;
    }

    @Test
    public void testSanitize() throws Exception {
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName name = ObjectName.getInstance("org.apache.camel:context=camel-1,type=endpoints,name=\"stub://foo\\?password=xxxxxx&username=foo\"");
        ManagedSanitizeTest.assertTrue((String)"Should be registered", (boolean)mbeanServer.isRegistered(name));
        String uri = (String)mbeanServer.getAttribute(name, "EndpointUri");
        ManagedSanitizeTest.assertEquals((Object)"stub://foo?password=xxxxxx&username=foo", (Object)uri);
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:start").routeId("foo").to("stub:foo?username=foo&password=secret")).to("mock:result");
                this.from("stub:foo?username=foo&password=secret").routeId("stub").to("mock:stub");
            }
        };
    }
}

