/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.openmbean.TabularData;
import org.apache.camel.CamelContext;
import org.apache.camel.Expression;
import org.apache.camel.ManagementStatisticsLevel;
import org.apache.camel.ServiceStatus;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.management.ManagementTestSupport;
import org.junit.Test;

public class ManagedRoutingSlipTest
extends ManagementTestSupport {
    protected CamelContext createCamelContext() throws Exception {
        CamelContext context = super.createCamelContext();
        context.init();
        context.getManagementStrategy().getManagementAgent().setStatisticsLevel(ManagementStatisticsLevel.Extended);
        return context;
    }

    @Test
    public void testManageRoutingSlip() throws Exception {
        if (ManagedRoutingSlipTest.isPlatform((String)"aix")) {
            return;
        }
        MockEndpoint foo = this.getMockEndpoint("mock:foo");
        foo.expectedMessageCount(2);
        MockEndpoint bar = this.getMockEndpoint("mock:bar");
        bar.expectedMessageCount(1);
        this.template.sendBodyAndHeader("direct:start", (Object)"Hello World", "whereTo", (Object)"direct:foo,direct:foo,direct:bar");
        this.assertMockEndpointsSatisfied();
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = ObjectName.getInstance("org.apache.camel:context=camel-1,type=processors,name=\"mysend\"");
        String routeId = (String)mbeanServer.getAttribute(on, "RouteId");
        ManagedRoutingSlipTest.assertEquals((Object)"route1", (Object)routeId);
        String camelId = (String)mbeanServer.getAttribute(on, "CamelId");
        ManagedRoutingSlipTest.assertEquals((Object)"camel-1", (Object)camelId);
        String state = (String)mbeanServer.getAttribute(on, "State");
        ManagedRoutingSlipTest.assertEquals((Object)ServiceStatus.Started.name(), (Object)state);
        String lan = (String)mbeanServer.getAttribute(on, "ExpressionLanguage");
        ManagedRoutingSlipTest.assertEquals((Object)"header", (Object)lan);
        String uri = (String)mbeanServer.getAttribute(on, "Expression");
        ManagedRoutingSlipTest.assertEquals((Object)"whereTo", (Object)uri);
        TabularData data = (TabularData)mbeanServer.invoke(on, "extendedInformation", null, null);
        ManagedRoutingSlipTest.assertNotNull((Object)data);
        ManagedRoutingSlipTest.assertEquals((long)2L, (long)data.size());
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").routingSlip((Expression)this.header("whereTo")).id("mysend");
                this.from("direct:foo").to("mock:foo");
                this.from("direct:bar").to("mock:bar");
            }
        };
    }
}

