/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.ServiceStatus;
import org.apache.camel.api.management.mbean.ManagedRouteMBean;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.RouteDefinition;
import org.junit.Test;

public class ManagedRouteStopUsingMBeanAPITest
extends ManagementTestSupport {
    @Test
    public void testStopRoute() throws Exception {
        if (ManagedRouteStopUsingMBeanAPITest.isPlatform((String)"aix")) {
            return;
        }
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        MBeanServer mbeanServer = this.getMBeanServer();
        Set<ObjectName> set = mbeanServer.queryNames(new ObjectName("*:type=routes,*"), null);
        ManagedRouteStopUsingMBeanAPITest.assertEquals((long)1L, (long)set.size());
        ObjectName on = set.iterator().next();
        ManagedRouteMBean mbean = (ManagedRouteMBean)this.context.getManagementStrategy().getManagementAgent().newProxyClient(on, ManagedRouteMBean.class);
        ManagedRouteStopUsingMBeanAPITest.assertEquals((Object)"direct://start", (Object)mbean.getEndpointUri());
        ManagedRouteStopUsingMBeanAPITest.assertEquals((String)"Should be started", (Object)ServiceStatus.Started.name(), (Object)mbean.getState());
        mbean.stop();
        ManagedRouteStopUsingMBeanAPITest.assertEquals((String)"Should be stopped", (Object)ServiceStatus.Stopped.name(), (Object)mbean.getState());
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:start").to("log:foo")).to("mock:result");
            }
        };
    }
}

