/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.ServiceStatus;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.management.ManagedRouteStopAndStartTest;
import org.awaitility.Awaitility;
import org.junit.Test;

public class ManagedRouteStopAndStartCleanupTest
extends ManagedRouteStopAndStartTest {
    @Override
    @Test
    public void testStopAndStartRoute() throws Exception {
        if (ManagedRouteStopAndStartCleanupTest.isPlatform((String)"aix")) {
            return;
        }
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = ManagedRouteStopAndStartCleanupTest.getRouteObjectName(mbeanServer);
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBodyAndHeader("file://target/data/managed", (Object)"Hello World", "CamelFileName", (Object)"hello.txt");
        this.assertMockEndpointsSatisfied();
        String state = (String)mbeanServer.getAttribute(on, "State");
        ManagedRouteStopAndStartCleanupTest.assertEquals((String)"Should be started", (Object)ServiceStatus.Started.name(), (Object)state);
        Awaitility.await().atMost(1L, TimeUnit.SECONDS).untilAsserted(() -> {
            Long completed = (Long)mbeanServer.getAttribute(on, "ExchangesCompleted");
            ManagedRouteStopAndStartCleanupTest.assertEquals((long)1L, (long)completed);
        });
        Set<ObjectName> set = mbeanServer.queryNames(new ObjectName("*:type=consumers,*"), null);
        ManagedRouteStopAndStartCleanupTest.assertEquals((String)"Should be 1 consumer", (long)1L, (long)set.size());
        set = mbeanServer.queryNames(new ObjectName("*:type=processors,*"), null);
        ManagedRouteStopAndStartCleanupTest.assertEquals((String)"Should be 2 processors", (long)2L, (long)set.size());
        this.log.info(">>>>>>>>>>>>>>>>>> invoking stop <<<<<<<<<<<<<<<<<<<<<");
        mbeanServer.invoke(on, "stop", null, null);
        this.log.info(">>>>>>>>>>>>>>>>>> invoking stop DONE <<<<<<<<<<<<<<<<<<<<<");
        state = (String)mbeanServer.getAttribute(on, "State");
        ManagedRouteStopAndStartCleanupTest.assertEquals((String)"Should be stopped", (Object)ServiceStatus.Stopped.name(), (Object)state);
        set = mbeanServer.queryNames(new ObjectName("*:type=consumers,*"), null);
        ManagedRouteStopAndStartCleanupTest.assertEquals((String)"Should be 0 consumer", (long)0L, (long)set.size());
        set = mbeanServer.queryNames(new ObjectName("*:type=processors,*"), null);
        ManagedRouteStopAndStartCleanupTest.assertEquals((String)"Should be 0 processor", (long)0L, (long)set.size());
        mock.reset();
        mock.expectedBodiesReceived(new Object[]{"Bye World"});
        mock.setResultWaitTime(2000L);
        this.template.sendBodyAndHeader("file://target/data/managed", (Object)"Bye World", "CamelFileName", (Object)"bye.txt");
        mock.assertIsNotSatisfied();
        mock.reset();
        mock.expectedBodiesReceived(new Object[]{"Bye World"});
        this.log.info(">>>>>>>>>>>>>>>>> invoking start <<<<<<<<<<<<<<<<<<");
        mbeanServer.invoke(on, "start", null, null);
        this.log.info(">>>>>>>>>>>>>>>>> invoking start DONE <<<<<<<<<<<<<<<<<<");
        state = (String)mbeanServer.getAttribute(on, "State");
        ManagedRouteStopAndStartCleanupTest.assertEquals((String)"Should be started", (Object)ServiceStatus.Started.name(), (Object)state);
        set = mbeanServer.queryNames(new ObjectName("*:type=consumers,*"), null);
        ManagedRouteStopAndStartCleanupTest.assertEquals((String)"Should be 1 consumer", (long)1L, (long)set.size());
        set = mbeanServer.queryNames(new ObjectName("*:type=processors,*"), null);
        ManagedRouteStopAndStartCleanupTest.assertEquals((String)"Should be 2 processors", (long)2L, (long)set.size());
        mock.assertIsSatisfied();
        Awaitility.await().atMost(1L, TimeUnit.SECONDS).until(() -> {
            Long num = (Long)mbeanServer.getAttribute(on, "ExchangesCompleted");
            return num == 2L;
        });
        Long completed = (Long)mbeanServer.getAttribute(on, "ExchangesCompleted");
        ManagedRouteStopAndStartCleanupTest.assertEquals((long)2L, (long)completed);
    }
}

