/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.Predicate;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.ChoiceDefinition;
import org.junit.Test;

public class ManagedRouteDirectWhileIssueLeakTest
extends ManagementTestSupport {
    @Test
    public void testInflightLeak() throws Exception {
        if (ManagedRouteDirectWhileIssueLeakTest.isPlatform((String)"aix")) {
            return;
        }
        MBeanServer mbeanServer = this.getMBeanServer();
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"AAAA"});
        this.template.sendBodyAndHeader("direct:start", (Object)"", "counter", (Object)4);
        this.assertMockEndpointsSatisfied();
        Set<ObjectName> set = mbeanServer.queryNames(new ObjectName("*:type=routes,*"), null);
        ManagedRouteDirectWhileIssueLeakTest.assertEquals((long)1L, (long)set.size());
        ObjectName on = set.iterator().next();
        Long inflight = (Long)mbeanServer.getAttribute(on, "ExchangesInflight");
        ManagedRouteDirectWhileIssueLeakTest.assertEquals((long)0L, (long)inflight);
        Long ts = (Long)mbeanServer.getAttribute(on, "OldestInflightDuration");
        ManagedRouteDirectWhileIssueLeakTest.assertNull((Object)ts);
        String id = (String)mbeanServer.getAttribute(on, "OldestInflightExchangeId");
        ManagedRouteDirectWhileIssueLeakTest.assertNull((Object)id);
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)this.from("direct:start").choice().when((Predicate)this.simple("${header.counter} > 0")).process(exchange -> {
                    String body = (String)exchange.getIn().getBody(String.class);
                    body = "A" + body;
                    exchange.getIn().setBody((Object)body);
                    int counter = (Integer)exchange.getIn().getHeader("counter", Integer.TYPE);
                    exchange.getIn().setHeader("counter", (Object)(--counter));
                })).to("direct:start")).otherwise().to("mock:result")).end();
            }
        };
    }
}

