/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.ServiceStatus;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockComponent;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.RouteDefinition;
import org.junit.Test;

public class ManagedRefProducerTest
extends ManagementTestSupport {
    protected CamelContext createCamelContext() throws Exception {
        CamelContext context = super.createCamelContext();
        context.getRegistry().bind("foo", (Object)new MockEndpoint("mock://foo", (Component)new MockComponent(context)));
        return context;
    }

    @Test
    public void testProducer() throws Exception {
        String uri;
        boolean registered;
        if (ManagedRefProducerTest.isPlatform((String)"aix")) {
            return;
        }
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.getMockEndpoint("foo").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        MBeanServer mbeanServer = this.getMBeanServer();
        Set<ObjectName> set = mbeanServer.queryNames(new ObjectName("*:type=producers,*"), null);
        ManagedRefProducerTest.assertEquals((long)2L, (long)set.size());
        for (ObjectName on : set) {
            registered = mbeanServer.isRegistered(on);
            ManagedRefProducerTest.assertEquals((String)"Should be registered", (Object)true, (Object)registered);
            uri = (String)mbeanServer.getAttribute(on, "EndpointUri");
            ManagedRefProducerTest.assertTrue((String)uri, (uri.equals("mock://foo") || uri.equals("mock://result") ? 1 : 0) != 0);
            String state = (String)mbeanServer.getAttribute(on, "State");
            ManagedRefProducerTest.assertEquals((String)"Should be started", (Object)ServiceStatus.Started.name(), (Object)state);
        }
        set = mbeanServer.queryNames(new ObjectName("*:type=endpoints,*"), null);
        ManagedRefProducerTest.assertEquals((long)4L, (long)set.size());
        for (ObjectName on : set) {
            registered = mbeanServer.isRegistered(on);
            ManagedRefProducerTest.assertEquals((String)"Should be registered", (Object)true, (Object)registered);
            uri = (String)mbeanServer.getAttribute(on, "EndpointUri");
            ManagedRefProducerTest.assertTrue((String)uri, (uri.equals("direct://start") || uri.equals("ref://foo") || uri.equals("mock://foo") || uri.equals("mock://result") ? 1 : 0) != 0);
        }
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:start").routeId("foo").to("ref:foo")).to("mock:result");
            }
        };
    }
}

