/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.ServiceStatus;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.impl.JndiRegistry;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.management.MyDummyProcessor;
import org.apache.camel.model.RouteDefinition;
import org.junit.Test;

public class ManagedProcessTest
extends ManagementTestSupport {
    protected JndiRegistry createRegistry() throws Exception {
        JndiRegistry jndi = super.createRegistry();
        jndi.bind("foo", (Object)new MyDummyProcessor());
        return jndi;
    }

    @Test
    public void testManageProcess() throws Exception {
        if (ManagedProcessTest.isPlatform((String)"aix")) {
            return;
        }
        MockEndpoint foo = this.getMockEndpoint("mock:foo");
        foo.expectedMessageCount(1);
        this.template.sendBodyAndHeader("direct:start", (Object)"Hello World", "foo", (Object)"123");
        this.assertMockEndpointsSatisfied();
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = ObjectName.getInstance("org.apache.camel:context=camel-1,type=processors,name=\"mysend\"");
        String routeId = (String)mbeanServer.getAttribute(on, "RouteId");
        ManagedProcessTest.assertEquals((Object)"route1", (Object)routeId);
        String camelId = (String)mbeanServer.getAttribute(on, "CamelId");
        ManagedProcessTest.assertEquals((Object)"camel-1", (Object)camelId);
        String state = (String)mbeanServer.getAttribute(on, "State");
        ManagedProcessTest.assertEquals((Object)ServiceStatus.Started.name(), (Object)state);
        String ref = (String)mbeanServer.getAttribute(on, "Ref");
        ManagedProcessTest.assertEquals((Object)"foo", (Object)ref);
        String processorClassName = (String)mbeanServer.getAttribute(on, "ProcessorClassName");
        ManagedProcessTest.assertEquals((Object)"org.apache.camel.management.MyDummyProcessor", (Object)processorClassName);
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)((RouteDefinition)this.from("direct:start").process("foo")).id("mysend")).to("mock:foo");
            }
        };
    }
}

