/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.Endpoint;
import org.apache.camel.Expression;
import org.apache.camel.Message;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.spi.IdempotentRepository;
import org.apache.camel.support.processor.idempotent.MemoryIdempotentRepository;
import org.junit.Before;
import org.junit.Test;

public class ManagedMemoryIdempotentConsumerTest
extends ManagementTestSupport {
    protected Endpoint startEndpoint;
    protected MockEndpoint resultEndpoint;
    private IdempotentRepository repo;

    @Test
    public void testDuplicateMessagesAreFilteredOut() throws Exception {
        if (ManagedMemoryIdempotentConsumerTest.isPlatform((String)"aix")) {
            return;
        }
        MBeanServer mbeanServer = this.getMBeanServer();
        Set<ObjectName> names = mbeanServer.queryNames(new ObjectName("org.apache.camel:type=services,*"), null);
        ObjectName on = null;
        for (ObjectName name : names) {
            if (!name.toString().contains("MemoryIdempotentRepository")) continue;
            on = name;
            break;
        }
        ManagedMemoryIdempotentConsumerTest.assertTrue((String)"Should be registered", (boolean)mbeanServer.isRegistered(on));
        Integer size = (Integer)mbeanServer.getAttribute(on, "CacheSize");
        ManagedMemoryIdempotentConsumerTest.assertEquals((long)1L, (long)size.intValue());
        ManagedMemoryIdempotentConsumerTest.assertFalse((boolean)this.repo.contains("1"));
        ManagedMemoryIdempotentConsumerTest.assertFalse((boolean)this.repo.contains("2"));
        ManagedMemoryIdempotentConsumerTest.assertFalse((boolean)this.repo.contains("3"));
        ManagedMemoryIdempotentConsumerTest.assertTrue((boolean)this.repo.contains("4"));
        this.resultEndpoint.expectedBodiesReceived(new Object[]{"one", "two", "three"});
        this.sendMessage("1", "one");
        this.sendMessage("2", "two");
        this.sendMessage("1", "one");
        this.sendMessage("2", "two");
        this.sendMessage("4", "four");
        this.sendMessage("1", "one");
        this.sendMessage("3", "three");
        this.resultEndpoint.assertIsSatisfied();
        ManagedMemoryIdempotentConsumerTest.assertTrue((boolean)this.repo.contains("1"));
        ManagedMemoryIdempotentConsumerTest.assertTrue((boolean)this.repo.contains("2"));
        ManagedMemoryIdempotentConsumerTest.assertTrue((boolean)this.repo.contains("3"));
        ManagedMemoryIdempotentConsumerTest.assertTrue((boolean)this.repo.contains("4"));
        size = (Integer)mbeanServer.getAttribute(on, "CacheSize");
        ManagedMemoryIdempotentConsumerTest.assertEquals((long)4L, (long)size.intValue());
        mbeanServer.invoke(on, "remove", new Object[]{"1"}, new String[]{"java.lang.String"});
        size = (Integer)mbeanServer.getAttribute(on, "CacheSize");
        ManagedMemoryIdempotentConsumerTest.assertEquals((long)3L, (long)size.intValue());
        ManagedMemoryIdempotentConsumerTest.assertFalse((boolean)this.repo.contains("1"));
        ManagedMemoryIdempotentConsumerTest.assertTrue((boolean)this.repo.contains("2"));
        ManagedMemoryIdempotentConsumerTest.assertTrue((boolean)this.repo.contains("3"));
        ManagedMemoryIdempotentConsumerTest.assertTrue((boolean)this.repo.contains("4"));
    }

    @Test
    public void testDuplicateMessagesCountAreCorrectlyCounted() throws Exception {
        if (ManagedMemoryIdempotentConsumerTest.isPlatform((String)"aix")) {
            return;
        }
        MBeanServer mbeanServer = this.getMBeanServer();
        Set<ObjectName> names = mbeanServer.queryNames(new ObjectName("org.apache.camel:type=processors,*"), null);
        ObjectName on = null;
        for (ObjectName name : names) {
            if (!name.toString().contains("idempotentConsumer")) continue;
            on = name;
            break;
        }
        ManagedMemoryIdempotentConsumerTest.assertTrue((String)"Should be registered", (boolean)mbeanServer.isRegistered(on));
        Long count = (Long)mbeanServer.getAttribute(on, "DuplicateMessageCount");
        ManagedMemoryIdempotentConsumerTest.assertEquals((long)0L, (long)count);
        this.resultEndpoint.expectedBodiesReceived(new Object[]{"one", "two"});
        this.sendMessage("1", "one");
        this.sendMessage("2", "two");
        this.sendMessage("1", "one");
        this.sendMessage("2", "two");
        this.resultEndpoint.assertIsSatisfied();
        count = (Long)mbeanServer.getAttribute(on, "DuplicateMessageCount");
        ManagedMemoryIdempotentConsumerTest.assertEquals((long)2L, (long)count);
        mbeanServer.invoke(on, "resetDuplicateMessageCount", null, null);
        count = (Long)mbeanServer.getAttribute(on, "DuplicateMessageCount");
        ManagedMemoryIdempotentConsumerTest.assertEquals((long)0L, (long)count);
        this.resetMocks();
        this.resultEndpoint.expectedBodiesReceived(new Object[]{"five"});
        this.sendMessage("4", "four");
        this.sendMessage("4", "four");
        this.sendMessage("5", "five");
        this.sendMessage("4", "four");
        this.resultEndpoint.assertIsSatisfied();
        count = (Long)mbeanServer.getAttribute(on, "DuplicateMessageCount");
        ManagedMemoryIdempotentConsumerTest.assertEquals((long)3L, (long)count);
    }

    protected void sendMessage(Object messageId, Object body) {
        this.template.send(this.startEndpoint, exchange -> {
            Message in = exchange.getIn();
            in.setBody(body);
            in.setHeader("messageId", messageId);
        });
    }

    @Override
    @Before
    public void setUp() throws Exception {
        this.repo = MemoryIdempotentRepository.memoryIdempotentRepository();
        this.repo.add("4");
        super.setUp();
        this.startEndpoint = this.resolveMandatoryEndpoint("direct:start");
        this.resultEndpoint = this.getMockEndpoint("mock:result");
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:start").idempotentConsumer((Expression)this.header("messageId"), ManagedMemoryIdempotentConsumerTest.this.repo).to("mock:result");
            }
        };
    }
}

