/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.RouteDefinition;
import org.junit.Test;

public class ManagedLogEndpointTest
extends ManagementTestSupport {
    @Test
    public void testLogEndpoint() throws Exception {
        if (ManagedLogEndpointTest.isPlatform((String)"aix")) {
            return;
        }
        this.getMockEndpoint("mock:a").expectedMessageCount(10);
        for (int i = 0; i < 10; ++i) {
            this.template.sendBody("direct:start", (Object)("" + i));
            Thread.sleep(100L);
        }
        this.assertMockEndpointsSatisfied();
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName name = ObjectName.getInstance("org.apache.camel:context=camel-1,type=processors,name=\"log-foo\"");
        mbeanServer.isRegistered(name);
        Long total = (Long)mbeanServer.getAttribute(name, "ExchangesTotal");
        ManagedLogEndpointTest.assertEquals((long)10L, (long)total.intValue());
        Integer received = (Integer)mbeanServer.getAttribute(name, "ReceivedCounter");
        ManagedLogEndpointTest.assertEquals((long)10L, (long)received.intValue());
        String last = (String)mbeanServer.getAttribute(name, "LastLogMessage");
        ManagedLogEndpointTest.assertNotNull((Object)last);
        ManagedLogEndpointTest.assertTrue((boolean)last.startsWith("Received: 10 messages so far."));
        Double rate = (Double)mbeanServer.getAttribute(name, "Rate");
        ManagedLogEndpointTest.assertNotNull((Object)rate);
        ManagedLogEndpointTest.assertTrue((rate > 0.0 ? 1 : 0) != 0);
        Double average = (Double)mbeanServer.getAttribute(name, "Average");
        ManagedLogEndpointTest.assertNotNull((Object)average);
        ManagedLogEndpointTest.assertTrue((average > 0.0 ? 1 : 0) != 0);
        mbeanServer.invoke(name, "resetThroughputLogger", null, null);
        total = (Long)mbeanServer.getAttribute(name, "ExchangesTotal");
        ManagedLogEndpointTest.assertEquals((long)10L, (long)total.intValue());
        last = (String)mbeanServer.getAttribute(name, "LastLogMessage");
        ManagedLogEndpointTest.assertNull((Object)last);
        received = (Integer)mbeanServer.getAttribute(name, "ReceivedCounter");
        ManagedLogEndpointTest.assertEquals((long)0L, (long)received.intValue());
        rate = (Double)mbeanServer.getAttribute(name, "Rate");
        ManagedLogEndpointTest.assertEquals((Object)0.0, (Object)rate);
        average = (Double)mbeanServer.getAttribute(name, "Average");
        ManagedLogEndpointTest.assertEquals((Object)0.0, (Object)average);
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)((RouteDefinition)this.from("direct:start").routeId("foo").to("log:foo?groupSize=10")).id("log-foo")).to("mock:a");
            }
        };
    }
}

