/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.RouteDefinition;
import org.awaitility.Awaitility;
import org.junit.Test;

public class ManagedInflightStatisticsTest
extends ManagementTestSupport {
    @Test
    public void testOldestInflight() throws Exception {
        if (ManagedInflightStatisticsTest.isPlatform((String)"aix")) {
            return;
        }
        MBeanServer mbeanServer = this.getMBeanServer();
        Set<ObjectName> set = mbeanServer.queryNames(new ObjectName("*:type=routes,*"), null);
        ManagedInflightStatisticsTest.assertEquals((long)1L, (long)set.size());
        ObjectName on = set.iterator().next();
        Long inflight = (Long)mbeanServer.getAttribute(on, "ExchangesInflight");
        ManagedInflightStatisticsTest.assertEquals((long)0L, (long)inflight);
        Long ts = (Long)mbeanServer.getAttribute(on, "OldestInflightDuration");
        ManagedInflightStatisticsTest.assertNull((Object)ts);
        String id = (String)mbeanServer.getAttribute(on, "OldestInflightExchangeId");
        ManagedInflightStatisticsTest.assertNull((Object)id);
        MockEndpoint result = this.getMockEndpoint("mock:result");
        result.expectedMessageCount(2);
        CountDownLatch latch1 = new CountDownLatch(1);
        CountDownLatch latch2 = new CountDownLatch(1);
        this.template.asyncSendBody("direct:start", (Object)latch1);
        Thread.sleep(250L);
        this.template.asyncSendBody("direct:start", (Object)latch2);
        Awaitility.await().atMost(2L, TimeUnit.SECONDS).until(() -> {
            Long num = (Long)mbeanServer.getAttribute(on, "ExchangesInflight");
            return num != null && num == 2L;
        });
        inflight = (Long)mbeanServer.getAttribute(on, "ExchangesInflight");
        ManagedInflightStatisticsTest.assertEquals((long)2L, (long)inflight);
        ts = (Long)mbeanServer.getAttribute(on, "OldestInflightDuration");
        ManagedInflightStatisticsTest.assertNotNull((Object)ts);
        id = (String)mbeanServer.getAttribute(on, "OldestInflightExchangeId");
        ManagedInflightStatisticsTest.assertNotNull((Object)id);
        this.log.info("Oldest Exchange id: {}, duration: {}", (Object)id, (Object)ts);
        latch1.countDown();
        Thread.sleep(200L);
        Long ts2 = (Long)mbeanServer.getAttribute(on, "OldestInflightDuration");
        ManagedInflightStatisticsTest.assertNotNull((Object)ts2);
        String id2 = (String)mbeanServer.getAttribute(on, "OldestInflightExchangeId");
        ManagedInflightStatisticsTest.assertNotNull((Object)id2);
        this.log.info("Oldest Exchange id: {}, duration: {}", (Object)id2, (Object)ts2);
        ManagedInflightStatisticsTest.assertTrue((!id2.equals(id) ? 1 : 0) != 0);
        ManagedInflightStatisticsTest.assertTrue((!Objects.equals(ts2, ts) ? 1 : 0) != 0);
        latch2.countDown();
        Awaitility.await().atMost(2L, TimeUnit.SECONDS).until(() -> {
            Long num = (Long)mbeanServer.getAttribute(on, "ExchangesInflight");
            return num != null && num == 0L;
        });
        this.assertMockEndpointsSatisfied();
        inflight = (Long)mbeanServer.getAttribute(on, "ExchangesInflight");
        ManagedInflightStatisticsTest.assertEquals((long)0L, (long)inflight);
        ts = (Long)mbeanServer.getAttribute(on, "OldestInflightDuration");
        ManagedInflightStatisticsTest.assertNull((Object)ts);
        id = (String)mbeanServer.getAttribute(on, "OldestInflightExchangeId");
        ManagedInflightStatisticsTest.assertNull((Object)id);
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)((RouteDefinition)this.from("direct:start").process(exchange -> {
                    CountDownLatch latch = (CountDownLatch)exchange.getIn().getBody();
                    latch.await(10L, TimeUnit.SECONDS);
                })).to("mock:result")).id("mock");
            }
        };
    }
}

