/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.Set;
import javax.management.Attribute;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.LoggingLevel;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.RouteDefinition;
import org.junit.Test;

public class ManagedErrorHandlerRedeliveryTest
extends ManagementTestSupport {
    private static int counter;

    @Test
    public void testManagedErrorHandlerRedelivery() throws Exception {
        if (ManagedErrorHandlerRedeliveryTest.isPlatform((String)"aix")) {
            return;
        }
        counter = 0;
        MBeanServer mbeanServer = this.getMBeanServer();
        Set<ObjectName> set = mbeanServer.queryNames(new ObjectName("*:type=errorhandlers,*"), null);
        ManagedErrorHandlerRedeliveryTest.assertEquals((long)1L, (long)set.size());
        ObjectName on = set.iterator().next();
        Integer max = (Integer)mbeanServer.getAttribute(on, "MaximumRedeliveries");
        ManagedErrorHandlerRedeliveryTest.assertEquals((long)5L, (long)max.intValue());
        Long delay = (Long)mbeanServer.getAttribute(on, "MaximumRedeliveryDelay");
        ManagedErrorHandlerRedeliveryTest.assertEquals((long)60000L, (long)delay);
        delay = (Long)mbeanServer.getAttribute(on, "RedeliveryDelay");
        ManagedErrorHandlerRedeliveryTest.assertEquals((long)1000L, (long)delay);
        String camelId = (String)mbeanServer.getAttribute(on, "CamelId");
        ManagedErrorHandlerRedeliveryTest.assertEquals((Object)"camel-1", (Object)camelId);
        Boolean dlc = (Boolean)mbeanServer.getAttribute(on, "DeadLetterChannel");
        ManagedErrorHandlerRedeliveryTest.assertEquals((Object)Boolean.FALSE, (Object)dlc);
        Boolean dlcom = (Boolean)mbeanServer.getAttribute(on, "DeadLetterUseOriginalMessage");
        ManagedErrorHandlerRedeliveryTest.assertEquals((Object)Boolean.FALSE, (Object)dlcom);
        Boolean tx = (Boolean)mbeanServer.getAttribute(on, "SupportTransactions");
        ManagedErrorHandlerRedeliveryTest.assertEquals((Object)Boolean.FALSE, (Object)tx);
        String dlcUri = (String)mbeanServer.getAttribute(on, "DeadLetterChannelEndpointUri");
        ManagedErrorHandlerRedeliveryTest.assertNull((Object)dlcUri);
        Double backoff = (Double)mbeanServer.getAttribute(on, "BackOffMultiplier");
        ManagedErrorHandlerRedeliveryTest.assertNotNull((Object)backoff);
        Double cf = (Double)mbeanServer.getAttribute(on, "CollisionAvoidanceFactor");
        ManagedErrorHandlerRedeliveryTest.assertNotNull((Object)cf);
        Double cp = (Double)mbeanServer.getAttribute(on, "CollisionAvoidancePercent");
        ManagedErrorHandlerRedeliveryTest.assertNotNull((Object)cp);
        String dp = (String)mbeanServer.getAttribute(on, "DelayPattern");
        ManagedErrorHandlerRedeliveryTest.assertNull((Object)dp);
        String ell = (String)mbeanServer.getAttribute(on, "RetriesExhaustedLogLevel");
        ManagedErrorHandlerRedeliveryTest.assertEquals((Object)LoggingLevel.ERROR.name(), (Object)ell);
        String rll = (String)mbeanServer.getAttribute(on, "RetryAttemptedLogLevel");
        ManagedErrorHandlerRedeliveryTest.assertEquals((Object)LoggingLevel.DEBUG.name(), (Object)rll);
        Boolean lst = (Boolean)mbeanServer.getAttribute(on, "LogStackTrace");
        ManagedErrorHandlerRedeliveryTest.assertEquals((Object)true, (Object)lst);
        Boolean lrst = (Boolean)mbeanServer.getAttribute(on, "LogRetryStackTrace");
        ManagedErrorHandlerRedeliveryTest.assertEquals((Object)false, (Object)lrst);
        Boolean uca = (Boolean)mbeanServer.getAttribute(on, "UseCollisionAvoidance");
        ManagedErrorHandlerRedeliveryTest.assertEquals((Object)false, (Object)uca);
        Boolean uebf = (Boolean)mbeanServer.getAttribute(on, "UseExponentialBackOff");
        ManagedErrorHandlerRedeliveryTest.assertEquals((Object)false, (Object)uebf);
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        ManagedErrorHandlerRedeliveryTest.assertEquals((long)3L, (long)counter);
        this.assertMockEndpointsSatisfied();
        counter = 0;
        mock.reset();
        mock.expectedMessageCount(0);
        mbeanServer.setAttribute(on, new Attribute("MaximumRedeliveries", 0));
        try {
            this.template.sendBody("direct:start", (Object)"Bye World");
            ManagedErrorHandlerRedeliveryTest.fail((String)"Should have thrown exception");
        }
        catch (CamelExecutionException e) {
            IllegalArgumentException cause = (IllegalArgumentException)ManagedErrorHandlerRedeliveryTest.assertIsInstanceOf(IllegalArgumentException.class, (Object)e.getCause());
            ManagedErrorHandlerRedeliveryTest.assertEquals((Object)"Forced", (Object)cause.getMessage());
        }
        ManagedErrorHandlerRedeliveryTest.assertEquals((long)1L, (long)counter);
        max = (Integer)mbeanServer.getAttribute(on, "MaximumRedeliveries");
        ManagedErrorHandlerRedeliveryTest.assertEquals((long)0L, (long)max.intValue());
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.errorHandler((ErrorHandlerBuilder)this.defaultErrorHandler().maximumRedeliveries(5));
                ((RouteDefinition)this.from("direct:start").process(exchange -> {
                    counter++;
                    if (counter < 3) {
                        throw new IllegalArgumentException("Forced");
                    }
                })).to("mock:result");
            }
        };
    }
}

