/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.Exchange;
import org.apache.camel.ServiceStatus;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.JndiRegistry;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.LoadBalanceDefinition;
import org.apache.camel.processor.loadbalancer.LoadBalancerSupport;
import org.junit.Test;

public class ManagedCustomLoadBalancerTest
extends ManagementTestSupport {
    protected JndiRegistry createRegistry() throws Exception {
        JndiRegistry jndi = super.createRegistry();
        jndi.bind("myBalancer", (Object)new MyLoadBalancer());
        return jndi;
    }

    @Test
    public void testManageCustomLoadBalancer() throws Exception {
        if (ManagedCustomLoadBalancerTest.isPlatform((String)"aix")) {
            return;
        }
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = ObjectName.getInstance("org.apache.camel:context=camel-1,type=processors,name=\"mysend\"");
        String routeId = (String)mbeanServer.getAttribute(on, "RouteId");
        ManagedCustomLoadBalancerTest.assertEquals((Object)"route1", (Object)routeId);
        String camelId = (String)mbeanServer.getAttribute(on, "CamelId");
        ManagedCustomLoadBalancerTest.assertEquals((Object)"camel-1", (Object)camelId);
        String state = (String)mbeanServer.getAttribute(on, "State");
        ManagedCustomLoadBalancerTest.assertEquals((Object)ServiceStatus.Started.name(), (Object)state);
        Integer size = (Integer)mbeanServer.getAttribute(on, "Size");
        ManagedCustomLoadBalancerTest.assertEquals((long)2L, (long)size.intValue());
        String ref = (String)mbeanServer.getAttribute(on, "Ref");
        ManagedCustomLoadBalancerTest.assertEquals((Object)"myBalancer", (Object)ref);
        String name = (String)mbeanServer.getAttribute(on, "LoadBalancerClassName");
        ManagedCustomLoadBalancerTest.assertEquals((Object)MyLoadBalancer.class.getName(), (Object)name);
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((LoadBalanceDefinition)this.from("direct:start").loadBalance().custom("myBalancer").id("mysend")).to(new String[]{"mock:foo", "mock:bar"});
            }
        };
    }

    public static class MyLoadBalancer
    extends LoadBalancerSupport {
        public boolean process(Exchange exchange, AsyncCallback callback) {
            String body = (String)exchange.getIn().getBody(String.class);
            try {
                if ("x".equals(body)) {
                    ((AsyncProcessor)this.getProcessors().get(0)).process(exchange);
                } else if ("y".equals(body)) {
                    ((AsyncProcessor)this.getProcessors().get(1)).process(exchange);
                } else {
                    ((AsyncProcessor)this.getProcessors().get(2)).process(exchange);
                }
            }
            catch (Throwable e) {
                exchange.setException(e);
            }
            callback.done(true);
            return true;
        }
    }
}

