/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.Component;
import org.apache.camel.ServiceStatus;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockComponent;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.RouteDefinition;
import org.junit.Test;

public class ManagedCustomComponentNameTest
extends ManagementTestSupport {
    @Test
    public void testCustomName() throws Exception {
        if (ManagedCustomComponentNameTest.isPlatform((String)"aix")) {
            return;
        }
        MBeanServer mbeanServer = this.getMBeanServer();
        Set<ObjectName> set = mbeanServer.queryNames(new ObjectName("*:type=components,*"), null);
        ManagedCustomComponentNameTest.assertEquals((long)3L, (long)set.size());
        ObjectName on = set.iterator().next();
        ManagedCustomComponentNameTest.assertTrue((String)"Should be registered", (boolean)mbeanServer.isRegistered(on));
        String state = (String)mbeanServer.getAttribute(on, "State");
        ManagedCustomComponentNameTest.assertEquals((Object)ServiceStatus.Started.name(), (Object)state);
        String id = (String)mbeanServer.getAttribute(on, "CamelId");
        ManagedCustomComponentNameTest.assertEquals((Object)"camel-1", (Object)id);
        this.context.stop();
        ManagedCustomComponentNameTest.assertFalse((String)"Should no longer be registered", (boolean)mbeanServer.isRegistered(on));
        set = mbeanServer.queryNames(new ObjectName("*:type=components,*"), null);
        ManagedCustomComponentNameTest.assertEquals((String)"Should no longer be registered", (long)0L, (long)set.size());
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ManagedCustomComponentNameTest.this.context.addComponent("foo", (Component)new MockComponent());
                ((RouteDefinition)this.from("direct:start").to("foo:foo")).to("mock:result");
            }
        };
    }
}

