/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.ArrayList;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.management.ManagementTestSupport;
import org.junit.Test;

public class ManagedBeanIntrospectionTest
extends ManagementTestSupport {
    public String getDummy() {
        return "MyDummy";
    }

    @Test
    public void testManageBeanIntrospection() throws Exception {
        if (ManagedBeanIntrospectionTest.isPlatform((String)"aix")) {
            return;
        }
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        MBeanServer mbeanServer = this.getMBeanServer();
        Set<ObjectName> set = mbeanServer.queryNames(new ObjectName("*:type=services,*"), null);
        ArrayList<ObjectName> list = new ArrayList<ObjectName>(set);
        ObjectName on = null;
        for (ObjectName name : list) {
            if (!name.getCanonicalName().contains("DefaultBeanIntrospection")) continue;
            on = name;
            break;
        }
        ManagedBeanIntrospectionTest.assertNotNull((String)"Should have found DefaultBeanIntrospection", on);
        mbeanServer.invoke(on, "resetCounters", null, null);
        Long counter = (Long)mbeanServer.getAttribute(on, "InvokedCounter");
        ManagedBeanIntrospectionTest.assertEquals((String)"Should not have been invoked", (long)0L, (long)counter.intValue());
        Object dummy = ((ExtendedCamelContext)this.context.adapt(ExtendedCamelContext.class)).getBeanIntrospection().getOrElseProperty((Object)this, "dummy", null, false);
        ManagedBeanIntrospectionTest.assertEquals((Object)"MyDummy", (Object)dummy);
        counter = (Long)mbeanServer.getAttribute(on, "InvokedCounter");
        ManagedBeanIntrospectionTest.assertEquals((String)"Should have been invoked", (long)1L, (long)counter.intValue());
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").to("mock:result");
            }
        };
    }
}

