/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.concurrent.TimeUnit;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.TimerListener;
import org.apache.camel.management.mbean.LoadTriplet;
import org.apache.camel.support.TimerListenerManager;
import org.awaitility.Awaitility;
import org.junit.Test;

public class LoadTimerTest
extends ContextTestSupport {
    private static final int SAMPLES = 2;

    public boolean isUseRouteBuilder() {
        return false;
    }

    @Test
    public void testTimer() throws Exception {
        TimerListenerManager myTimer = new TimerListenerManager();
        myTimer.setCamelContext((CamelContext)this.context);
        myTimer.start();
        TestLoadAware test = new TestLoadAware();
        myTimer.addTimerListener((TimerListener)test);
        try {
            Awaitility.await().atMost(5L, TimeUnit.SECONDS).untilAsserted(() -> {
                LoadTimerTest.assertTrue((test.counter >= 2 ? 1 : 0) != 0);
                LoadTimerTest.assertFalse((boolean)Double.isNaN(test.load.getLoad1()));
                LoadTimerTest.assertTrue((test.load.getLoad1() > 0.0 ? 1 : 0) != 0);
                LoadTimerTest.assertTrue((test.load.getLoad1() < 2.0 ? 1 : 0) != 0);
            });
        }
        finally {
            myTimer.removeTimerListener((TimerListener)test);
        }
        myTimer.stop();
    }

    private class TestLoadAware
    implements TimerListener {
        volatile int counter;
        LoadTriplet load = new LoadTriplet();

        private TestLoadAware() {
        }

        public void onTimer() {
            this.load.update(++this.counter);
        }
    }
}

