/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.rmi.NoSuchObjectException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.Locale;
import java.util.Random;
import javax.management.MBeanServerConnection;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.camel.management.JmxInstrumentationUsingDefaultsTest;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class JmxInstrumentationWithConnectorTest
extends JmxInstrumentationUsingDefaultsTest {
    protected String url;
    protected JMXConnector clientConnector;
    protected int registryPort;

    @Override
    protected boolean useJmx() {
        return true;
    }

    protected boolean canRunOnThisPlatform() {
        String os = System.getProperty("os.name");
        boolean aix = os.toLowerCase(Locale.ENGLISH).contains("aix");
        boolean windows = os.toLowerCase(Locale.ENGLISH).contains("windows");
        boolean solaris = os.toLowerCase(Locale.ENGLISH).contains("sunos");
        return !aix && !solaris && !windows;
    }

    @Override
    @Before
    public void setUp() throws Exception {
        this.registryPort = 30000 + new Random().nextInt(10000);
        this.log.info("Using port " + this.registryPort);
        this.url = "service:jmx:rmi:///jndi/rmi://localhost:" + this.registryPort + "/jmxrmi/camel";
        System.setProperty("org.apache.camel.jmx.usePlatformMBeanServer", "false");
        System.setProperty("org.apache.camel.jmx.createRmiConnector", "true");
        System.setProperty("org.apache.camel.jmx.rmiConnector.registryPort", "" + this.registryPort);
        super.setUp();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        if (this.clientConnector != null) {
            try {
                this.clientConnector.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.clientConnector = null;
        }
        System.clearProperty("org.apache.camel.jmx.usePlatformMBeanServer");
        System.clearProperty("org.apache.camel.jmx.mbeanServerDefaultDomain");
        System.clearProperty("org.apache.camel.jmx.mbeanObjectDomainName");
        System.clearProperty("org.apache.camel.jmx.createRmiConnector");
        System.clearProperty("org.apache.camel.jmx.rmiConnector.registryPort");
        super.tearDown();
    }

    @Override
    protected MBeanServerConnection getMBeanConnection() throws Exception {
        if (this.mbsc == null) {
            if (this.clientConnector == null) {
                this.clientConnector = JMXConnectorFactory.connect(new JMXServiceURL(this.url), null);
            }
            this.mbsc = this.clientConnector.getMBeanServerConnection();
        }
        return this.mbsc;
    }

    @Test
    public void testRmiRegistryUnexported() throws Exception {
        NoSuchObjectException e2;
        NoSuchObjectException e;
        Registry registry = LocateRegistry.getRegistry(this.registryPort);
        try {
            registry.list();
            e = null;
        }
        catch (NoSuchObjectException nsoe) {
            e = nsoe;
        }
        JmxInstrumentationWithConnectorTest.assertNull((Object)e);
        this.context.stop();
        try {
            registry.list();
            e2 = null;
        }
        catch (NoSuchObjectException nsoe) {
            e2 = nsoe;
        }
        JmxInstrumentationWithConnectorTest.assertNotNull((Object)e2);
    }
}

