/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.Set;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.management.JmxInstrumentationUsingPropertiesTest;
import org.junit.Test;

public class JmxInstrumentationDisableTest
extends JmxInstrumentationUsingPropertiesTest {
    @Override
    protected boolean useJmx() {
        return false;
    }

    @Override
    @Test
    public void testMBeansRegistered() throws Exception {
        if (JmxInstrumentationDisableTest.isPlatform((String)"aix")) {
            return;
        }
        this.assertDefaultDomain();
        this.resolveMandatoryEndpoint("mock:end", MockEndpoint.class);
        Set<ObjectName> s = this.mbsc.queryNames(new ObjectName(this.domainName + ":type=endpoints,*"), null);
        JmxInstrumentationDisableTest.assertEquals((String)("Could not find 0 endpoints: " + s), (long)0L, (long)s.size());
        s = this.mbsc.queryNames(new ObjectName(this.domainName + ":type=contexts,*"), null);
        JmxInstrumentationDisableTest.assertEquals((String)("Could not find 0 context: " + s), (long)0L, (long)s.size());
        s = this.mbsc.queryNames(new ObjectName(this.domainName + ":type=processors,*"), null);
        JmxInstrumentationDisableTest.assertEquals((String)("Could not find 0 processor: " + s), (long)0L, (long)s.size());
        s = this.mbsc.queryNames(new ObjectName(this.domainName + ":type=routes,*"), null);
        JmxInstrumentationDisableTest.assertEquals((String)("Could not find 0 route: " + s), (long)0L, (long)s.size());
    }

    @Override
    protected void verifyCounter(MBeanServerConnection beanServer, ObjectName name) throws Exception {
        Set<ObjectName> s = beanServer.queryNames(name, null);
        JmxInstrumentationDisableTest.assertEquals((String)("Found mbeans: " + s), (long)0L, (long)s.size());
    }
}

