/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.ThreadsDefinition;
import org.junit.Test;

public class DualManagedThreadPoolWithIdTest
extends ManagementTestSupport {
    @Test
    public void testManagedThreadPool() throws Exception {
        if (DualManagedThreadPoolWithIdTest.isPlatform((String)"aix")) {
            return;
        }
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = ObjectName.getInstance("org.apache.camel:context=camel-1,type=threadpools,name=\"myThreads(threads)\"");
        Integer corePoolSize = (Integer)mbeanServer.getAttribute(on, "CorePoolSize");
        DualManagedThreadPoolWithIdTest.assertEquals((long)15L, (long)corePoolSize.intValue());
        Integer maxPoolSize = (Integer)mbeanServer.getAttribute(on, "MaximumPoolSize");
        DualManagedThreadPoolWithIdTest.assertEquals((long)30L, (long)maxPoolSize.intValue());
        String id = (String)mbeanServer.getAttribute(on, "Id");
        DualManagedThreadPoolWithIdTest.assertEquals((Object)"myThreads", (Object)id);
        String source = (String)mbeanServer.getAttribute(on, "SourceId");
        DualManagedThreadPoolWithIdTest.assertEquals((Object)"threads", (Object)source);
        String route = (String)mbeanServer.getAttribute(on, "RouteId");
        DualManagedThreadPoolWithIdTest.assertEquals((Object)"route1", (Object)route);
        on = ObjectName.getInstance("org.apache.camel:context=camel-1,type=threadpools,name=\"myOtherThreads(threads)\"");
        corePoolSize = (Integer)mbeanServer.getAttribute(on, "CorePoolSize");
        DualManagedThreadPoolWithIdTest.assertEquals((long)1L, (long)corePoolSize.intValue());
        maxPoolSize = (Integer)mbeanServer.getAttribute(on, "MaximumPoolSize");
        DualManagedThreadPoolWithIdTest.assertEquals((long)2L, (long)maxPoolSize.intValue());
        id = (String)mbeanServer.getAttribute(on, "Id");
        DualManagedThreadPoolWithIdTest.assertEquals((Object)"myOtherThreads", (Object)id);
        source = (String)mbeanServer.getAttribute(on, "SourceId");
        DualManagedThreadPoolWithIdTest.assertEquals((Object)"threads", (Object)source);
        route = (String)mbeanServer.getAttribute(on, "RouteId");
        DualManagedThreadPoolWithIdTest.assertEquals((Object)"route2", (Object)route);
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((ThreadsDefinition)this.from("direct:start").threads(15, 30).id("myThreads")).to("mock:result");
                ((ThreadsDefinition)this.from("direct:foo").threads(1, 2).id("myOtherThreads")).to("mock:foo");
            }
        };
    }
}

