/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.List;
import javax.management.Attribute;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.Exchange;
import org.apache.camel.api.management.mbean.BacklogTracerEventMessage;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.RouteDefinition;
import org.junit.Test;

public class BacklogTracerFilterTest
extends ManagementTestSupport {
    @Test
    public void testBacklogTracerFilter() throws Exception {
        if (BacklogTracerFilterTest.isPlatform((String)"aix")) {
            return;
        }
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = new ObjectName("org.apache.camel:context=camel-1,type=tracer,name=BacklogTracer");
        BacklogTracerFilterTest.assertNotNull((Object)on);
        mbeanServer.isRegistered(on);
        Boolean enabled = (Boolean)mbeanServer.getAttribute(on, "Enabled");
        BacklogTracerFilterTest.assertEquals((String)"Should not be enabled", (Object)Boolean.FALSE, (Object)enabled);
        Integer size = (Integer)mbeanServer.getAttribute(on, "BacklogSize");
        BacklogTracerFilterTest.assertEquals((String)"Should be 1000", (long)1000L, (long)size.intValue());
        mbeanServer.setAttribute(on, new Attribute("TraceFilter", "${header.foo} != null"));
        mbeanServer.setAttribute(on, new Attribute("Enabled", Boolean.TRUE));
        this.getMockEndpoint("mock:foo").expectedMessageCount(2);
        this.getMockEndpoint("mock:bar").expectedMessageCount(2);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.template.sendBodyAndHeader("direct:start", (Object)"Bye World", "foo", (Object)123);
        this.assertMockEndpointsSatisfied();
        List exchanges = this.getMockEndpoint("mock:foo").getReceivedExchanges();
        List events = (List)mbeanServer.invoke(on, "dumpAllTracedMessages", null, null);
        BacklogTracerFilterTest.assertNotNull((Object)events);
        BacklogTracerFilterTest.assertEquals((long)3L, (long)events.size());
        BacklogTracerEventMessage event = (BacklogTracerEventMessage)events.get(0);
        BacklogTracerFilterTest.assertEquals(null, (Object)event.getToNode());
        BacklogTracerFilterTest.assertEquals((Object)("    <message exchangeId=\"" + ((Exchange)exchanges.get(1)).getExchangeId() + "\">\n      <headers>\n        <header key=\"foo\" type=\"java.lang.Integer\">123</header>\n      </headers>\n      <body type=\"java.lang.String\">Bye World</body>\n    </message>"), (Object)event.getMessageAsXml());
        BacklogTracerEventMessage event1 = (BacklogTracerEventMessage)events.get(1);
        BacklogTracerFilterTest.assertEquals((Object)"foo", (Object)event1.getToNode());
        BacklogTracerFilterTest.assertEquals((Object)("    <message exchangeId=\"" + ((Exchange)exchanges.get(1)).getExchangeId() + "\">\n      <headers>\n        <header key=\"foo\" type=\"java.lang.Integer\">123</header>\n      </headers>\n      <body type=\"java.lang.String\">Bye World</body>\n    </message>"), (Object)event1.getMessageAsXml());
        BacklogTracerEventMessage event2 = (BacklogTracerEventMessage)events.get(2);
        BacklogTracerFilterTest.assertEquals((Object)"bar", (Object)event2.getToNode());
        BacklogTracerFilterTest.assertEquals((Object)("    <message exchangeId=\"" + ((Exchange)exchanges.get(1)).getExchangeId() + "\">\n      <headers>\n        <header key=\"foo\" type=\"java.lang.Integer\">123</header>\n      </headers>\n      <body type=\"java.lang.String\">Bye World</body>\n    </message>"), (Object)event2.getMessageAsXml());
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                BacklogTracerFilterTest.this.context.setUseBreadcrumb(Boolean.valueOf(false));
                BacklogTracerFilterTest.this.context.setBacklogTracing(Boolean.valueOf(true));
                ((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from("direct:start").to("mock:foo")).id("foo")).to("mock:bar")).id("bar");
            }
        };
    }
}

