/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.junit.Before;
import org.junit.Test;

public class NoErrorHandlerTest
extends ContextTestSupport {
    private static int counter;
    private static boolean jmx;

    @Before
    public void setUp() throws Exception {
        counter = 0;
        super.setUp();
    }

    protected boolean useJmx() {
        return jmx;
    }

    @Test
    public void testNoErrorHandler() throws Exception {
        this.doTest();
    }

    @Test
    public void testNoErrorHandlerJMXDisabled() throws Exception {
        this.doTest();
    }

    private void doTest() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Goodday World"});
        try {
            this.template.sendBody("direct:start", (Object)"Hello World");
            NoErrorHandlerTest.fail((String)"Should have thrown an exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.template.sendBody("direct:start", (Object)"Bye World");
            NoErrorHandlerTest.fail((String)"Should have thrown an exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.template.sendBody("direct:start", (Object)"Goodday World");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.errorHandler((ErrorHandlerBuilder)this.noErrorHandler());
                ((RouteDefinition)this.from("direct:start").process(exchange -> {
                    if (++counter < 3) {
                        throw new IllegalArgumentException("Forced by unit test");
                    }
                })).to("mock:result");
            }
        };
    }

    static {
        jmx = true;
    }
}

