/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.ArrayList;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.RouteDefinition;
import org.junit.Test;

public class RemoveRouteDefinitionTest
extends ManagementTestSupport {
    @Test
    public void testShutdownRoute() throws Exception {
        if (RemoveRouteDefinitionTest.isPlatform((String)"aix")) {
            return;
        }
        MBeanServer mbeanServer = this.getMBeanServer();
        Set<ObjectName> set = mbeanServer.queryNames(new ObjectName("*:type=routes,*"), null);
        RemoveRouteDefinitionTest.assertEquals((long)1L, (long)set.size());
        ObjectName on = set.iterator().next();
        boolean registered = mbeanServer.isRegistered(on);
        RemoveRouteDefinitionTest.assertTrue((String)"Should be registered", (boolean)registered);
        this.context.getRouteController().stopRoute("route1");
        this.context.removeRoute("route1");
        set = mbeanServer.queryNames(new ObjectName("*:type=routes,*"), null);
        RemoveRouteDefinitionTest.assertEquals((long)0L, (long)set.size());
    }

    @Test
    public void testStopAndRemoveRoute() throws Exception {
        if (RemoveRouteDefinitionTest.isPlatform((String)"aix")) {
            return;
        }
        MBeanServer mbeanServer = this.getMBeanServer();
        Set<ObjectName> set = mbeanServer.queryNames(new ObjectName("*:type=routes,*"), null);
        RemoveRouteDefinitionTest.assertEquals((long)1L, (long)set.size());
        ObjectName on = set.iterator().next();
        boolean registered = mbeanServer.isRegistered(on);
        RemoveRouteDefinitionTest.assertEquals((String)"Should be registered", (Object)true, (Object)registered);
        RouteDefinition definition = this.context.getRouteDefinition("route1");
        ArrayList<RouteDefinition> routeDefinitions = new ArrayList<RouteDefinition>();
        routeDefinitions.add(definition);
        this.context.getRouteController().stopRoute("route1");
        this.context.removeRoute("route1");
        set = mbeanServer.queryNames(new ObjectName("*:type=routes,*"), null);
        RemoveRouteDefinitionTest.assertEquals((long)0L, (long)set.size());
    }

    @Test
    public void testStopRoute() throws Exception {
        if (RemoveRouteDefinitionTest.isPlatform((String)"aix")) {
            return;
        }
        MBeanServer mbeanServer = this.getMBeanServer();
        Set<ObjectName> set = mbeanServer.queryNames(new ObjectName("*:type=routes,*"), null);
        RemoveRouteDefinitionTest.assertEquals((long)1L, (long)set.size());
        ObjectName on = set.iterator().next();
        boolean registered = mbeanServer.isRegistered(on);
        RemoveRouteDefinitionTest.assertEquals((String)"Should be registered", (Object)true, (Object)registered);
        RouteDefinition definition = this.context.getRouteDefinition("route1");
        ArrayList<RouteDefinition> routeDefinitions = new ArrayList<RouteDefinition>();
        routeDefinitions.add(definition);
        this.context.getRouteController().stopRoute("route1");
        set = mbeanServer.queryNames(new ObjectName("*:type=routes,*"), null);
        RemoveRouteDefinitionTest.assertEquals((long)1L, (long)set.size());
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:start").routeId("route1").to("log:foo")).to("mock:result");
            }
        };
    }
}

