/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.management.ManagementTestSupport;
import org.junit.Test;

public class ManagedUnregisterEndpointTest
extends ManagementTestSupport {
    @Test
    public void testUnregisterEndpoint() throws Exception {
        if (ManagedUnregisterEndpointTest.isPlatform((String)"aix")) {
            return;
        }
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = ObjectName.getInstance("org.apache.camel:context=camel-1,type=endpoints,name=\"mock://result\"");
        ManagedUnregisterEndpointTest.assertTrue((String)"Should be registered", (boolean)mbeanServer.isRegistered(on));
        String uri = (String)mbeanServer.getAttribute(on, "EndpointUri");
        ManagedUnregisterEndpointTest.assertEquals((Object)"mock://result", (Object)uri);
        this.context.stop();
        ManagedUnregisterEndpointTest.assertFalse((String)"Should no longer be registered", (boolean)mbeanServer.isRegistered(on));
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").to("mock:result");
            }
        };
    }
}

