/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.ServiceStatus;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.management.ManagementTestSupport;
import org.junit.Test;

public class ManagedUnregisterConsumerTest
extends ManagementTestSupport {
    @Test
    public void testUnregisterConsumer() throws Exception {
        if (ManagedUnregisterConsumerTest.isPlatform((String)"aix")) {
            return;
        }
        MBeanServer mbeanServer = this.getMBeanServer();
        Set<ObjectName> set = mbeanServer.queryNames(new ObjectName("*:type=consumers,*"), null);
        ManagedUnregisterConsumerTest.assertEquals((long)1L, (long)set.size());
        ObjectName on = set.iterator().next();
        ManagedUnregisterConsumerTest.assertTrue((String)"Should be registered", (boolean)mbeanServer.isRegistered(on));
        String uri = (String)mbeanServer.getAttribute(on, "EndpointUri");
        ManagedUnregisterConsumerTest.assertEquals((Object)"direct://start", (Object)uri);
        String routeId = (String)mbeanServer.getAttribute(on, "RouteId");
        ManagedUnregisterConsumerTest.assertEquals((Object)"route1", (Object)routeId);
        String camelId = (String)mbeanServer.getAttribute(on, "CamelId");
        ManagedUnregisterConsumerTest.assertEquals((Object)"camel-1", (Object)camelId);
        String state = (String)mbeanServer.getAttribute(on, "State");
        ManagedUnregisterConsumerTest.assertEquals((Object)ServiceStatus.Started.name(), (Object)state);
        this.context.stop();
        ManagedUnregisterConsumerTest.assertFalse((String)"Should no longer be registered", (boolean)mbeanServer.isRegistered(on));
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").to("mock:result");
            }
        };
    }
}

