/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.ServiceStatus;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.LoadBalanceDefinition;
import org.junit.Test;

public class ManagedTopicLoadBalancerTest
extends ManagementTestSupport {
    @Test
    public void testManageTopicLoadBalancer() throws Exception {
        if (ManagedTopicLoadBalancerTest.isPlatform((String)"aix")) {
            return;
        }
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = ObjectName.getInstance("org.apache.camel:context=camel-1,type=processors,name=\"mysend\"");
        String routeId = (String)mbeanServer.getAttribute(on, "RouteId");
        ManagedTopicLoadBalancerTest.assertEquals((Object)"route1", (Object)routeId);
        String camelId = (String)mbeanServer.getAttribute(on, "CamelId");
        ManagedTopicLoadBalancerTest.assertEquals((Object)"camel-1", (Object)camelId);
        String state = (String)mbeanServer.getAttribute(on, "State");
        ManagedTopicLoadBalancerTest.assertEquals((Object)ServiceStatus.Started.name(), (Object)state);
        Integer size = (Integer)mbeanServer.getAttribute(on, "Size");
        ManagedTopicLoadBalancerTest.assertEquals((long)2L, (long)size.intValue());
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((LoadBalanceDefinition)this.from("direct:start").loadBalance().topic().id("mysend")).to(new String[]{"mock:foo", "mock:bar"});
            }
        };
    }
}

