/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.Set;
import javax.management.Attribute;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.CamelContext;
import org.apache.camel.ManagementStatisticsLevel;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.management.ManagementTestSupport;
import org.junit.Test;

public class ManagedStatisticsLevelOffTest
extends ManagementTestSupport {
    protected CamelContext createCamelContext() throws Exception {
        CamelContext context = super.createCamelContext();
        context.init();
        context.getManagementStrategy().getManagementAgent().setStatisticsLevel(ManagementStatisticsLevel.Off);
        return context;
    }

    @Test
    public void testManageStatisticsLevelDisabled() throws Exception {
        if (ManagedStatisticsLevelOffTest.isPlatform((String)"aix")) {
            return;
        }
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.template.sendBody("direct:start", (Object)"Bye World");
        MBeanServer mbeanServer = this.getMBeanServer();
        Set<ObjectName> set = mbeanServer.queryNames(new ObjectName("*:type=routes,*"), null);
        ManagedStatisticsLevelOffTest.assertEquals((long)1L, (long)set.size());
        ObjectName on = set.iterator().next();
        Long completed = (Long)mbeanServer.getAttribute(on, "ExchangesCompleted");
        ManagedStatisticsLevelOffTest.assertEquals((long)0L, (long)completed);
        mbeanServer.setAttribute(on, new Attribute("StatisticsEnabled", true));
        this.template.sendBody("direct:start", (Object)"Goodday World");
        completed = (Long)mbeanServer.getAttribute(on, "ExchangesCompleted");
        ManagedStatisticsLevelOffTest.assertEquals((long)1L, (long)completed);
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").to("mock:result");
            }
        };
    }
}

