/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.ServiceStatus;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.management.ManagementTestSupport;
import org.junit.Test;

public class ManagedSedaRouteRemoveTest
extends ManagementTestSupport {
    @Test
    public void testRemove() throws Exception {
        if (ManagedSedaRouteRemoveTest.isPlatform((String)"aix")) {
            return;
        }
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = ManagedSedaRouteRemoveTest.getRouteObjectName(mbeanServer);
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBody("seda:foo", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        String state = (String)mbeanServer.getAttribute(on, "State");
        ManagedSedaRouteRemoveTest.assertEquals((String)"Should be started", (Object)ServiceStatus.Started.name(), (Object)state);
        Set<ObjectName> set = mbeanServer.queryNames(new ObjectName("*:type=threadpools,*"), null);
        boolean seda = false;
        for (ObjectName names : set) {
            if (!names.toString().contains("Seda")) continue;
            seda = true;
            break;
        }
        ManagedSedaRouteRemoveTest.assertTrue((String)"There should be a seda thread pool", (boolean)seda);
        mbeanServer.invoke(on, "stop", null, null);
        state = (String)mbeanServer.getAttribute(on, "State");
        ManagedSedaRouteRemoveTest.assertEquals((String)"Should be stopped", (Object)ServiceStatus.Stopped.name(), (Object)state);
        mbeanServer.invoke(on, "remove", null, null);
        boolean registered = mbeanServer.isRegistered(on);
        ManagedSedaRouteRemoveTest.assertFalse((String)"Route mbean should have been unregistered", (boolean)registered);
        set = mbeanServer.queryNames(new ObjectName("*:type=routes,*"), null);
        ManagedSedaRouteRemoveTest.assertEquals((long)0L, (long)set.size());
        set = mbeanServer.queryNames(new ObjectName("*:type=threadpools,*"), null);
        seda = false;
        for (ObjectName names : set) {
            if (!names.toString().contains("Seda")) continue;
            seda = true;
            break;
        }
        ManagedSedaRouteRemoveTest.assertFalse((String)"There should not be a seda thread pool", (boolean)seda);
    }

    static ObjectName getRouteObjectName(MBeanServer mbeanServer) throws Exception {
        Set<ObjectName> set = mbeanServer.queryNames(new ObjectName("*:type=routes,*"), null);
        ManagedSedaRouteRemoveTest.assertEquals((long)1L, (long)set.size());
        return set.iterator().next();
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("seda:foo").to("mock:result");
            }
        };
    }
}

