/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.ServiceStatus;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.RouteDefinition;
import org.junit.Before;
import org.junit.Test;

public class ManagedRouteStopAndStartTest
extends ManagementTestSupport {
    @Override
    @Before
    public void setUp() throws Exception {
        ManagedRouteStopAndStartTest.deleteDirectory((String)"target/data/managed");
        super.setUp();
    }

    @Test
    public void testStopAndStartRoute() throws Exception {
        if (ManagedRouteStopAndStartTest.isPlatform((String)"aix")) {
            return;
        }
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = ManagedRouteStopAndStartTest.getRouteObjectName(mbeanServer);
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBodyAndHeader("file://target/data/managed", (Object)"Hello World", "CamelFileName", (Object)"hello.txt");
        this.assertMockEndpointsSatisfied();
        String state = (String)mbeanServer.getAttribute(on, "State");
        ManagedRouteStopAndStartTest.assertEquals((String)"Should be started", (Object)ServiceStatus.Started.name(), (Object)state);
        String id = (String)mbeanServer.getAttribute(on, "RouteId");
        ManagedRouteStopAndStartTest.assertEquals((Object)"foo", (Object)id);
        String description = (String)mbeanServer.getAttribute(on, "Description");
        ManagedRouteStopAndStartTest.assertEquals((Object)"This is the foo route", (Object)description);
        mbeanServer.invoke(on, "stop", null, null);
        state = (String)mbeanServer.getAttribute(on, "State");
        ManagedRouteStopAndStartTest.assertEquals((String)"Should be stopped", (Object)ServiceStatus.Stopped.name(), (Object)state);
        mock.reset();
        mock.expectedBodiesReceived(new Object[]{"Bye World"});
        mock.setResultWaitTime(100L);
        this.template.sendBodyAndHeader("file://target/data/managed", (Object)"Bye World", "CamelFileName", (Object)"bye.txt");
        mock.assertIsNotSatisfied();
        mock.reset();
        mock.expectedBodiesReceived(new Object[]{"Bye World"});
        mbeanServer.invoke(on, "start", null, null);
        state = (String)mbeanServer.getAttribute(on, "State");
        ManagedRouteStopAndStartTest.assertEquals((String)"Should be started", (Object)ServiceStatus.Started.name(), (Object)state);
        mock.assertIsSatisfied();
    }

    static ObjectName getRouteObjectName(MBeanServer mbeanServer) throws Exception {
        Set<ObjectName> set = mbeanServer.queryNames(new ObjectName("*:type=routes,*"), null);
        ManagedRouteStopAndStartTest.assertEquals((long)1L, (long)set.size());
        return set.iterator().next();
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("file://target/data/managed?initialDelay=0&delay=10").routeId("foo").routeDescription("This is the foo route").convertBodyTo(String.class)).to("mock:result");
            }
        };
    }
}

