/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.ServiceStatus;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.management.ManagementTestSupport;
import org.junit.Before;
import org.junit.Test;

public class ManagedRouteShutdownAndStartTest
extends ManagementTestSupport {
    @Override
    @Before
    public void setUp() throws Exception {
        ManagedRouteShutdownAndStartTest.deleteDirectory((String)"target/data/managed");
        super.setUp();
    }

    @Test
    public void testShutdownAndStartRoute() throws Exception {
        if (ManagedRouteShutdownAndStartTest.isPlatform((String)"aix")) {
            return;
        }
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = ManagedRouteShutdownAndStartTest.getRouteObjectName(mbeanServer);
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBodyAndHeader("file://target/data/managed", (Object)"Hello World", "CamelFileName", (Object)"hello.txt");
        this.assertMockEndpointsSatisfied();
        String state = (String)mbeanServer.getAttribute(on, "State");
        ManagedRouteShutdownAndStartTest.assertEquals((String)"Should be started", (Object)ServiceStatus.Started.name(), (Object)state);
        mbeanServer.invoke(on, "stop", null, null);
        mbeanServer.invoke(on, "remove", null, null);
        ManagedRouteShutdownAndStartTest.assertFalse((String)"The managed route should be removed", (boolean)mbeanServer.isRegistered(on));
        mock.reset();
        mock.expectedBodiesReceived(new Object[]{"Bye World"});
        mock.setResultWaitTime(250L);
        this.template.sendBodyAndHeader("file://target/data/managed", (Object)"Bye World", "CamelFileName", (Object)"bye.txt");
        mock.assertIsNotSatisfied();
    }

    static ObjectName getRouteObjectName(MBeanServer mbeanServer) throws Exception {
        Set<ObjectName> set = mbeanServer.queryNames(new ObjectName("*:type=routes,*"), null);
        ManagedRouteShutdownAndStartTest.assertEquals((long)1L, (long)set.size());
        return set.iterator().next();
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("file://target/data/managed?initialDelay=0&delay=10").to("mock:result");
            }
        };
    }
}

